/*
 * Decompiled with CFR 0.152.
 */
package oc;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oc.BuildaHQ;
import oc.OptionsVater;
import oc.RefreshListener;
import org.w3c.dom.Element;

public class AnzahlPanel
extends OptionsVater
implements KeyListener {
    private int minModelle;
    private int maxModelle;
    private int modelle = -1;
    private double preis;
    private double grundkosten = 0.0;
    private boolean controlled;
    private boolean legal = true;
    private boolean nichtDieErsteOption;
    private boolean zeilenumbruchZuvor = false;
    private boolean abschaltbar;
    private String name;
    private String kurzerName = null;
    private String langerName = null;
    private String singularName = null;
    private JButton bWeniger;
    private JButton bMehr;
    private JTextField tModelle;
    private JLabel lName;
    private int gesamtBreiteButtons;
    private Font unControlledFont = new Font("arial", 2, 12);
    private Font controlledFont = new Font("arial", 0, 12);

    public void setName(String name) {
        this.name = name;
        this.lNameTextGenerieren();
    }

    public void setNichtDieErsteOption(boolean b) {
        this.nichtDieErsteOption = b;
    }

    public void setZeilenumbruchZuvor(boolean b) {
        this.zeilenumbruchZuvor = b;
    }

    public void setGrundkosten(double i) {
        this.grundkosten = i;
    }

    public void setMaxModelle(int i) {
        this.maxModelle = i;
        if (this.getModelle() > this.maxModelle) {
            this.setModelle(this.maxModelle);
        }
    }

    @Override
    public void setLegal(boolean b) {
        if (this.legal != b) {
            if (b) {
                this.bWeniger.setForeground(Color.BLACK);
                this.bMehr.setForeground(Color.BLACK);
                this.tModelle.setForeground(Color.BLACK);
            } else {
                this.bWeniger.setForeground(Color.RED);
                this.bMehr.setForeground(Color.RED);
                this.tModelle.setForeground(Color.RED);
            }
        }
        this.legal = b;
    }

    @Override
    public boolean isLegal() {
        return this.legal;
    }

    @Override
    public boolean isSelected() {
        return this.modelle > 0 || this.preis == -88.0;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public double getKosten() {
        if (this.preis == -88.0) {
            return 0.0;
        }
        return this.grundkosten + this.preis * (double)this.modelle;
    }

    public int getModelle() {
        return this.modelle;
    }

    public AnzahlPanel(int ID, int lX, int lY, String name, int minModelle, int maxModelle, double preis) {
        this.init(ID, lX, lY, name, minModelle, maxModelle, preis);
    }

    public AnzahlPanel(int ID, int lX, int lY, String singular, String name, int minModelle, int maxModelle, double preis) {
        this.singularName = singular;
        this.init(ID, lX, lY, name, minModelle, maxModelle, preis);
    }

    public AnzahlPanel(int ID, int lX, int lY, String kurzerName, int minModelle, int maxModelle, String name, String langerName, int start) {
        this.modelle = start;
        this.kurzerName = kurzerName;
        this.langerName = langerName;
        this.init(ID, lX, lY, name, minModelle, maxModelle, -88.0);
    }

    public AnzahlPanel(int ID, int lX, int lY, String kurzerName, int minModelle, int maxModelle, double preis, String name) {
        this.kurzerName = kurzerName;
        this.init(ID, lX, lY, name, minModelle, maxModelle, preis);
    }

    public void init(int ID, int lX, int lY, String name, int minModelle, int maxModelle, double preis) {
        this.name = name;
        this.minModelle = minModelle;
        this.maxModelle = maxModelle;
        if (this.modelle == -1) {
            this.modelle = minModelle;
        }
        this.preis = preis;
        this.produceButtons();
        this.panel.setLocation(lX, lY);
        this.tModelle.addKeyListener(this);
        new RefreshListener(1, ID){

            @Override
            public void refresh() {
                AnzahlPanel.this.control();
            }
        };
    }

    public void produceButtons() {
        this.panel.setSize(380 - (int)this.panel.getLocation().getX(), 18);
        this.bWeniger = new JButton("<");
        this.bMehr = new JButton(">");
        BuildaHQ.newGUIComponent(this.bWeniger);
        BuildaHQ.newGUIComponent(this.bMehr);
        this.tModelle = new JTextField(String.valueOf(this.modelle));
        BuildaHQ.newGUIComponent(this.tModelle);
        this.lName = new JLabel("");
        this.lName.setFont(new Font("arial", 0, 12));
        this.lName.setBackground(Color.WHITE);
        this.lNameTextGenerieren();
        this.bWeniger.setBounds(0, 2, 41, 16);
        this.tModelle.setBounds(43, 1, 31, 18);
        this.bMehr.setBounds(75, 2, 41, 16);
        this.bMehr.setMargin(new Insets(0, 0, 0, 0));
        this.bWeniger.setMargin(new Insets(0, 0, 0, 0));
        this.gesamtBreiteButtons = 92;
        this.lName.setBounds(125, 2, 400 - this.gesamtBreiteButtons, 16);
        this.panel.add(this.bWeniger);
        this.panel.add(this.bMehr);
        this.panel.add(this.tModelle);
        this.panel.add(this.lName);
        this.bWeniger.addMouseListener(this);
        this.bMehr.addMouseListener(this);
    }

    public void lNameTextGenerieren() {
        String n = this.kurzerName != null ? this.kurzerName : this.name;
        if (this.singularName != null && this.getModelle() == 1) {
            n = this.singularName;
        }
        FontMetrics fm = this.lName.getFontMetrics(this.lName.getFont());
        StringBuilder abstandshalter = new StringBuilder("");
        int cnt = (this.panel.getSize().width - 130 - fm.stringWidth(String.valueOf(n) + BuildaHQ.translate("jeweils") + " " + this.entferneNullNachkomma(this.preis) + " " + BuildaHQ.translate("Pkt."))) / fm.stringWidth(" .");
        int i = 0;
        while (i < cnt) {
            abstandshalter.append(" .");
            ++i;
        }
        this.lName.setText(String.valueOf(n) + abstandshalter.toString() + BuildaHQ.translate("jeweils") + " " + this.entferneNullNachkomma(this.preis) + " " + BuildaHQ.translate("Pkt."));
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (((JButton)event.getSource()).getText().equals("<")) {
            if (event.getButton() == 2) {
                this.modelle = this.abschaltbar ? 0 : this.minModelle;
            } else if (this.abschaltbar && this.modelle - 1 < this.minModelle) {
                this.modelle = 0;
            } else if (this.modelle - 1 >= this.minModelle) {
                --this.modelle;
            }
        } else if (((JButton)event.getSource()).getText().equals(">")) {
            if (this.modelle == 0 && this.abschaltbar) {
                this.modelle = this.minModelle;
            } else if (event.getButton() == 2) {
                this.modelle = this.maxModelle;
            } else if (this.modelle + 1 <= this.maxModelle) {
                ++this.modelle;
            }
        }
        this.tModelle.setText(String.valueOf(this.modelle));
        this.controlled = false;
        RefreshListener.fireRefresh();
        if (this.singularName != null) {
            this.lNameTextGenerieren();
        }
    }

    public void control() {
        if (!this.controlled) {
            if (this.modelle > this.maxModelle) {
                this.modelle = this.maxModelle;
            }
            if (this.modelle < this.minModelle) {
                this.modelle = this.abschaltbar ? 0 : this.minModelle;
            }
            this.setModelle(this.modelle);
            this.controlled = true;
            this.tModelle.setFont(this.controlledFont);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int anzahl = this.minModelle;
        try {
            anzahl = Integer.parseInt(this.tModelle.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setModelle(anzahl);
        this.tModelle.setFont(this.unControlledFont);
        this.controlled = false;
    }

    @Override
    public void setModelle(int anzahl) {
        this.modelle = anzahl;
        this.tModelle.setText(String.valueOf(this.modelle));
    }

    public void setAbschaltbar(boolean b) {
        this.abschaltbar = b;
    }

    @Override
    public String getText() {
        String kosten = "";
        if (BuildaHQ.allePunktkosten) {
            kosten = this.getKosten() == 0.0 ? "   " + BuildaHQ.translate("kostenlos") : "   " + this.entferneNullNachkomma(this.getKosten()) + " " + BuildaHQ.translate("Pkt.");
        }
        String n = this.name;
        if (this.singularName != null && this.getModelle() == 1) {
            n = this.singularName;
        }
        if (this.langerName != null && !BuildaHQ.kurzerText) {
            n = this.langerName;
        }
        if (this.preis == -88.0) {
            return BuildaHQ.formatierFett(String.valueOf(this.nichtDieErsteOption ? BuildaHQ.abstand : "") + n + ": " + this.getModelle());
        }
        if (this.nichtDieErsteOption) {
            return String.valueOf(BuildaHQ.abstand) + BuildaHQ.formatierFett(String.valueOf(this.getModelle()) + " " + n) + kosten;
        }
        return String.valueOf(BuildaHQ.formatierFett(String.valueOf(this.zeilenumbruchZuvor ? "\n" : "") + this.getModelle() + " " + n)) + kosten;
    }

    @Override
    public String getSaveText() {
        this.control();
        return String.valueOf(this.getModelle());
    }

    @Override
    public Element getSaveElement() {
        this.control();
        Element root = BuildaHQ.getNewXMLElement("Counter");
        root.setAttribute("number", Integer.toString(this.getModelle()));
        return root;
    }

    @Override
    public void load(String s) {
        try {
            this.modelle = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            this.modelle = -88;
        }
        this.tModelle.setText(String.valueOf(this.modelle));
    }

    @Override
    public void loadElement(Element e) {
        try {
            this.modelle = Integer.parseInt(e.getAttribute("number"));
        }
        catch (NumberFormatException ex) {
            this.modelle = -88;
        }
    }

    @Override
    public String getLabel() {
        return "";
    }
}

