/*
 * Decompiled with CFR 0.152.
 */
package oc;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import oc.BuildaHQ;
import oc.BuildaSTK;
import oc.OnlineCodex;

public class BuildaMenu
extends JFrame
implements BuildaSTK {
    private static final long serialVersionUID = 1L;
    public static JCheckBox bilderAneigen = new JCheckBox("", true);
    JTextArea tMausradSpeed = new JTextArea(String.valueOf(40));
    JLabel lMausradSpeed = new JLabel(BuildaHQ.translate("Geschwindigkeit des Mausrads:"));
    JTextArea tPfeiltastenSpeed = new JTextArea(String.valueOf(50));
    JLabel lPfeiltastenSpeed = new JLabel(BuildaHQ.translate("Geschwindigkeit der Pfeiltasten:"));
    JCheckBox vertikalScrollen = new JCheckBox("", true);
    JLabel lVertikalScrollen = new JLabel(BuildaHQ.translate("Scrollrichtung umdrehen"));
    JCheckBox bildaz = new JCheckBox("", true);
    JLabel lBildaz = new JLabel(BuildaHQ.translate("Bilder"));
    JButton cleanBuilda = new JButton(BuildaHQ.translate("Leere aktuelles Dokument"));
    JButton ok = new JButton(BuildaHQ.translate("OK"));
    JCheckBox apo = new JCheckBox("", false);
    JLabel lApo = new JLabel(BuildaHQ.translate("Apokalypse"));
    boolean apoSelected = false;
    KeyListener closeKeyListener = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 10 || event.getKeyCode() == 27) {
                BuildaMenu.this.closeBuildaMenu();
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }
    };
    WindowListener windowListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            BuildaMenu.this.savePrefs();
        }
    };
    ActionListener closeActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            BuildaMenu.this.closeBuildaMenu();
        }
    };
    ActionListener dokumentLeerenListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            int choose = JOptionPane.showOptionDialog(null, BuildaHQ.translate("Wollen Sie wirklich alle Eintr\u00e4ge des aktiven Volkes l\u00f6schen?"), BuildaHQ.translate("Wirklich l\u00f6schen?"), -1, 3, null, new Object[]{BuildaHQ.translate("Ja"), BuildaHQ.translate("Nein")}, BuildaHQ.translate("Ja"));
            if (choose == 0) {
                OnlineCodex.getInstance().dokumentLeeren();
                BuildaMenu.this.closeBuildaMenu();
            }
        }
    };

    public BuildaMenu() {
        super(BuildaHQ.translate("Einstellungen"));
        this.setLayout(null);
        this.setBounds(200, 200, 584, 320);
        this.getContentPane().setBackground(Color.WHITE);
        this.setResizable(false);
        this.setIconImage(BuildaHQ.oCLogo);
        int XX = 15;
        int cnt = 10;
        this.lMausradSpeed.setBounds(XX, cnt, 190, 18);
        this.tMausradSpeed.setBounds(XX + 195, cnt + 2, 35, 18);
        this.lVertikalScrollen.setBounds(XX, cnt += 22, 180, 18);
        this.vertikalScrollen.setBounds(XX + 195 - 3, cnt, 30, 18);
        this.lPfeiltastenSpeed.setBounds(XX, cnt += 25, 190, 18);
        this.tPfeiltastenSpeed.setBounds(XX + 195, cnt + 2, 35, 18);
        String h1 = BuildaHQ.translate("Hier kann man ver\u00e4ndern, wie schnell mit dem Mausrad gescrollt wird");
        this.lMausradSpeed.setToolTipText(h1);
        this.tMausradSpeed.setToolTipText(h1);
        h1 = BuildaHQ.translate("Hier kann man ver\u00e4ndern, wie schnell mit den Pfeiltasten gescrollt wird");
        this.lPfeiltastenSpeed.setToolTipText(h1);
        this.tPfeiltastenSpeed.setToolTipText(h1);
        this.tMausradSpeed.setFont(new Font("arial", 0, 14));
        this.tPfeiltastenSpeed.setFont(new Font("arial", 0, 14));
        this.tMausradSpeed.addKeyListener(this.closeKeyListener);
        this.tPfeiltastenSpeed.addKeyListener(this.closeKeyListener);
        this.vertikalScrollen.setBackground(Color.WHITE);
        h1 = BuildaHQ.translate("<html>Dreht das scrollen mit dem Mausrad um. Normalerweise wird oben-unten, bei gedr\u00fcckten STRG links-rechts gescrollt.<br>Wenn angehakt, wird links-rechts gescrollt, wenn STRG gedr\u00fcckt ist, oben-unten.</html>");
        this.vertikalScrollen.setToolTipText(h1);
        this.lVertikalScrollen.setToolTipText(h1);
        h1 = BuildaHQ.translate("Hier kann man einstellen, ob Apokalypse-Einheiten ausgew\u00e4hlt werden k\u00f6nnen oder nicht.");
        this.lBildaz.setBounds(XX, cnt += 25, 180, 18);
        this.bildaz.setBounds(XX + 195 - 3, cnt, 30, 18);
        this.bildaz.setBackground(Color.WHITE);
        h1 = BuildaHQ.translate("Es werden keine Bilder angezeigt. Verkleinert manche Eintr\u00e4ge.");
        this.bildaz.setToolTipText(h1);
        this.lBildaz.setToolTipText(h1);
        cnt += 31;
        this.add(this.lMausradSpeed);
        this.add(this.tMausradSpeed);
        this.add(this.lVertikalScrollen);
        this.add(this.vertikalScrollen);
        this.add(this.lPfeiltastenSpeed);
        this.add(this.tPfeiltastenSpeed);
        this.add(this.bildaz);
        this.add(this.lBildaz);
        this.cleanBuilda.setBounds(XX - 1, cnt, 226 - XX - 40, 18);
        this.cleanBuilda.setMargin(new Insets(0, 0, 0, 0));
        this.cleanBuilda.setBorder(null);
        this.cleanBuilda.setFont(new Font("arial", 1, 11));
        this.cleanBuilda.addActionListener(this.dokumentLeerenListener);
        this.cleanBuilda.setToolTipText(BuildaHQ.translate("L\u00f6scht alle Eintr\u00e4ge des aktiven Volkes."));
        this.add(this.cleanBuilda);
        this.ok.setBounds(this.getSize().width - 90, this.getSize().height - 77, 76, 17);
        this.ok.setBorder(null);
        this.add(this.ok);
        this.getRootPane().setDefaultButton(this.ok);
        this.ok.addKeyListener(this.closeKeyListener);
        this.ok.addActionListener(this.closeActionListener);
        JLabel ico = BuildaHQ.createPictureJLabel("oc/sysimages/smArtwork.gif");
        ico.setLocation(260, 12);
        this.add(ico);
        this.loadPrefs();
    }

    public void closeBuildaMenu() {
        this.setVisible(false);
    }

    public int getMausradSpeed() {
        try {
            return Integer.parseInt(this.tMausradSpeed.getText());
        }
        catch (NumberFormatException e) {
            this.tMausradSpeed.setText(String.valueOf(40));
            return 40;
        }
    }

    public int getPfeiltastenSpeed() {
        try {
            return Integer.parseInt(this.tPfeiltastenSpeed.getText());
        }
        catch (NumberFormatException e) {
            this.tPfeiltastenSpeed.setText(String.valueOf(50));
            return 50;
        }
    }

    public boolean isBildaz() {
        return this.bildaz.isSelected();
    }

    public boolean isApo() {
        return this.apo.isSelected();
    }

    public boolean isVertikalScrolling() {
        return this.vertikalScrollen.isSelected();
    }

    public BuildaMenu getInstance() {
        return this;
    }

    public void savePrefs() {
        Preferences prefs = OnlineCodex.getInstance().getPrefs();
        prefs.putBoolean("enableApocalpyse", this.isApo());
        prefs.putBoolean("showPictures", this.isBildaz());
        prefs.putBoolean("scrollVertical", this.isVertikalScrolling());
        prefs.putInt("mouseWheelSpeed", this.getMausradSpeed());
        prefs.putInt("arrowKeysSpeed", this.getPfeiltastenSpeed());
    }

    public void loadPrefs() {
        Preferences prefs = OnlineCodex.getInstance().getPrefs();
        this.apo.setSelected(prefs.getBoolean("enableApocalpyse", this.isApo()));
        this.bildaz.setSelected(prefs.getBoolean("showPictures", this.isBildaz()));
        this.vertikalScrollen.setSelected(prefs.getBoolean("scrollVertical", this.isVertikalScrolling()));
        this.tMausradSpeed.setText(Integer.toString(prefs.getInt("mouseWheelSpeed", this.getMausradSpeed())));
        this.tPfeiltastenSpeed.setText(Integer.toString(prefs.getInt("arrowKeysSpeed", this.getPfeiltastenSpeed())));
    }
}

