/*
 * Decompiled with CFR 0.152.
 */
package oc;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oc.BuildaHQ;
import oc.BuildaPanel;
import oc.BuildaSTK;
import oc.ChooserGruppe;
import oc.Information;
import oc.JTextAreaWithPopup;
import oc.ModalDialog;
import oc.RefreshListener;
import oc.Sonstige;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class BuildaVater
extends BuildaPanel
implements ActionListener,
ItemListener,
BuildaSTK {
    private Information informationClass;
    private Vector<ChooserGruppe> myChooserGruppen = new Vector();
    private JScrollPane textAreaScrollPane;
    private JTextAreaWithPopup textArea = new JTextAreaWithPopup(true, false);
    private Sonstige[] sonstige;
    private JButton markieren = new JButton(BuildaHQ.translate("Alles markieren"));
    private JCheckBox htmlStyleCheckBox = new JCheckBox(BuildaHQ.translate("Easy-HTML Formatierung"), BuildaHQ.formatierung == 1);
    private JCheckBox alleKostenCheckBox = new JCheckBox(BuildaHQ.translate("Alle Punktkosten"), BuildaHQ.allePunktkosten);
    private JCheckBox kurzerTextCheckBox = new JCheckBox(BuildaHQ.translate("Kurze Armeeliste"), BuildaHQ.kurzerText);
    private JCheckBox sterneAnzeigenCheckBox = new JCheckBox(BuildaHQ.translate("Sterne anzeigen"), BuildaHQ.sterneAnzeigen);
    private JCheckBox zusatzInfosCheckBox = new JCheckBox(BuildaHQ.translate("Zus\u00e4tzliche Informationen"), BuildaHQ.zusatzInfos);
    private JCheckBox excelModeCheckBox = new JCheckBox(BuildaHQ.translate("F\u00fchrende Leerzeichen"), BuildaHQ.excelMode);
    protected boolean nurBeiLeerenBuilderTrue = false;
    protected int cnt = 0;
    protected String textAreaUeberschrift = "";
    protected String nameDerArtDerArmee = "";
    protected String nameDerArtDerArmeeDekliniert = "";
    protected String anfangDerTextarea = "";
    private boolean geaddet = false;

    public String getText() {
        return this.textArea.getText();
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    public BuildaVater() {
        this.panel.setBackground(Color.WHITE);
        this.panel.setBounds(0, 0, 4500, 9100);
    }

    public void complete() {
        if (!this.nurBeiLeerenBuilderTrue) {
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
            this.textArea.setFont(Font.decode("Courier New"));
            this.textArea.setToolTipText(BuildaHQ.translate("Zum rauskopieren Strg+C benutzen"));
            BuildaHQ.newGUIComponent(this.textArea);
            this.textArea.removeMouseWheelListener(BuildaHQ.defaultMouseWheelListener);
            this.textAreaScrollPane = new JScrollPane(this.textArea);
            this.textAreaScrollPane.setBounds(this.cnt, 70, 600, 645);
            this.textAreaScrollPane.setBorder(BorderFactory.createTitledBorder(null, this.textAreaUeberschrift.replace("Meine", BuildaHQ.translate("Meine")), 2, 3, new Font("Viner Hand ITC", 1, 16)));
            this.textAreaScrollPane.setBackground(Color.WHITE);
            this.panel.add(this.textAreaScrollPane);
            this.markieren.setBounds(this.cnt, 12, 135, 20);
            this.markieren.addActionListener(this);
            BuildaHQ.newGUIComponent(this.markieren);
            this.markieren.setToolTipText(BuildaHQ.translate("Zum rauskopieren Strg+C benutzen"));
            this.panel.add(this.markieren);
            this.htmlStyleCheckBox.setBounds(this.cnt + 160, 10, 185, 20);
            this.htmlStyleCheckBox.setBackground(Color.WHITE);
            this.htmlStyleCheckBox.addItemListener(this);
            BuildaHQ.newGUIComponent(this.htmlStyleCheckBox);
            this.htmlStyleCheckBox.setToolTipText(BuildaHQ.translate("Unbedingt anhaken, wenn die Armeeliste in ein Forum kopiert werden soll"));
            this.panel.add(this.htmlStyleCheckBox);
            this.alleKostenCheckBox.setBounds(this.cnt + 160, 40, 185, 20);
            this.alleKostenCheckBox.setBackground(Color.WHITE);
            this.alleKostenCheckBox.addItemListener(this);
            BuildaHQ.newGUIComponent(this.alleKostenCheckBox);
            this.panel.add(this.alleKostenCheckBox);
            this.kurzerTextCheckBox.setBounds(this.cnt + 350, 10, 120, 20);
            this.kurzerTextCheckBox.setBackground(Color.WHITE);
            this.kurzerTextCheckBox.addItemListener(this);
            this.kurzerTextCheckBox.setMargin(new Insets(0, 0, 0, 0));
            BuildaHQ.newGUIComponent(this.kurzerTextCheckBox);
            this.panel.add(this.kurzerTextCheckBox);
            this.sterneAnzeigenCheckBox.setBounds(this.cnt + 350, 40, 120, 20);
            this.sterneAnzeigenCheckBox.setBackground(Color.WHITE);
            this.sterneAnzeigenCheckBox.addItemListener(this);
            BuildaHQ.newGUIComponent(this.sterneAnzeigenCheckBox);
            this.panel.add(this.sterneAnzeigenCheckBox);
            this.zusatzInfosCheckBox.setBounds(this.cnt + 510, 10, 185, 20);
            this.zusatzInfosCheckBox.setBackground(Color.WHITE);
            this.zusatzInfosCheckBox.addItemListener(this);
            this.zusatzInfosCheckBox.setSelected(true);
            BuildaHQ.newGUIComponent(this.zusatzInfosCheckBox);
            this.panel.add(this.zusatzInfosCheckBox);
            this.excelModeCheckBox.setBounds(this.cnt + 510, 40, 185, 20);
            this.excelModeCheckBox.setBackground(Color.WHITE);
            this.excelModeCheckBox.addItemListener(this);
            BuildaHQ.newGUIComponent(this.excelModeCheckBox);
            this.panel.add(this.excelModeCheckBox);
            this.armeelistenFormatAnpassen(true);
            new RefreshListener(13){

                @Override
                public void refresh() {
                    BuildaVater.this.textAreaRefresh();
                }
            };
        }
    }

    @Override
    public double getKosten() {
        double kosten = 0.0;
        int i = 0;
        while (i < this.myChooserGruppen.size()) {
            kosten += this.myChooserGruppen.elementAt(i).getKosten();
            ++i;
        }
        return kosten;
    }

    protected String getVolksSpezifischeInfos() {
        return this.anfangDerTextarea;
    }

    public void textAreaRefresh() {
        boolean vielText;
        StringBuilder text = new StringBuilder(this.getVolksSpezifischeInfos());
        text.append("\n");
        if (BuildaHQ.zusatzInfos) {
            text.append(this.zusatzInformationen());
        }
        String lzpzu = " \n";
        int i = 0;
        while (i < this.myChooserGruppen.size()) {
            String str = this.myChooserGruppen.elementAt(i).getText();
            if (BuildaHQ.excelMode && !str.equals("")) {
                str = str.replaceAll("\n", " \n");
                String[] tokens = str.split("\n");
                int j = 0;
                while (j < tokens.length) {
                    String token = tokens[j];
                    String trimtok = token.trim();
                    if (trimtok.startsWith("-")) {
                        token = token.replaceFirst("-", "-");
                    } else if (trimtok.startsWith("+")) {
                        token = token.replaceFirst("\\+", " \\+");
                    }
                    text.append(token);
                    if (j < tokens.length - 1) {
                        text.append("\n");
                    }
                    ++j;
                }
                text.append("\n");
            } else {
                text.append(str);
            }
            ++i;
        }
        text.append(BuildaHQ.formatierFettItalicUnderline("\n" + BuildaHQ.translate("Gesamtpunkte") + " " + this.nameDerArtDerArmeeDekliniert + " : " + this.entferneNullNachkomma(this.getKosten()) + "\n"));
        this.textArea.setText(text.toString());
        boolean bl = vielText = this.textArea.getText().split("\n").length > 37;
        if (this.geaddet && vielText) {
            this.textArea.removeMouseWheelListener(BuildaHQ.defaultMouseWheelListener);
            this.geaddet = false;
        } else if (!this.geaddet && !vielText) {
            this.textArea.addMouseWheelListener(BuildaHQ.defaultMouseWheelListener);
            this.geaddet = true;
        }
        try {
            this.textArea.select(0, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String zusatzInformationen() {
        StringBuilder text = new StringBuilder(this.getVolksSpezifischeInfos());
        double gesPkt = 0.0;
        double gesProz = 0.0;
        if (text.toString().length() != 0) {
            text.append("\n");
        }
        int i = 0;
        while (i < this.myChooserGruppen.size()) {
            ChooserGruppe cg = this.myChooserGruppen.elementAt(i);
            double anz = cg.getAnzahl();
            String kat = cg.kategorieText();
            String format = "";
            if (cg.getAnzahl() > 0.0) {
                double pkt = cg.getKosten();
                double proz = cg.getProzentKosten() / Double.valueOf(budget.getText()) * 100.0;
                gesPkt += pkt;
                gesProz += proz;
                format = String.format("  %2.0f  %-20s %6.1f Pkt.\t%5.1f %% ", anz, kat, pkt, proz);
            } else {
                format = String.format("  %2.0f  %-15s ", anz, kat);
            }
            text.append(String.valueOf(format) + "\n");
            ++i;
        }
        if (BuildaHQ.kurzerText) {
            text.append("\n");
        }
        text.append("\n");
        text.append(String.format("      %-20s %6.1f Pkt.\t%5.1f %%     ", "Gesamt:", gesPkt, gesProz));
        text.append("\n");
        return text.toString();
    }

    public void adden(ChooserGruppe c) {
        this.myChooserGruppen.addElement(c);
        this.panel.add(this.myChooserGruppen.lastElement().getPanel());
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        this.armeelistenFormatAnpassen((JCheckBox)event.getSource() == this.kurzerTextCheckBox);
    }

    public void armeelistenFormatAnpassen(boolean kurzeTextAnpassen) {
        BuildaHQ.formatierung = this.htmlStyleCheckBox.isSelected() ? 1 : 0;
        BuildaHQ.allePunktkosten = this.alleKostenCheckBox.isSelected();
        BuildaHQ.sterneAnzeigen = this.sterneAnzeigenCheckBox.isSelected();
        BuildaHQ.zusatzInfos = this.zusatzInfosCheckBox.isSelected();
        BuildaHQ.excelMode = this.excelModeCheckBox.isSelected();
        if (kurzeTextAnpassen) {
            BuildaHQ.machTextStrings(this.kurzerTextCheckBox.isSelected());
        }
        this.textAreaRefresh();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.textArea.selectAll();
        this.textArea.requestFocusInWindow();
    }

    public String getSaveText() {
        StringBuilder sammler = new StringBuilder();
        int i = 0;
        while (i < this.myChooserGruppen.size()) {
            sammler.append(this.myChooserGruppen.elementAt(i).getSaveText());
            sammler.append("_5T");
            ++i;
        }
        return sammler.toString();
    }

    public String getSaveTextAllies() {
        StringBuilder sammler = new StringBuilder();
        int i = 0;
        while (i < this.myChooserGruppen.size()) {
            sammler.append(this.myChooserGruppen.elementAt(i).getSaveTextAllies());
            sammler.append("_5T");
            ++i;
        }
        return sammler.toString();
    }

    public String getSaveTextApo() {
        StringBuilder sammler = new StringBuilder();
        int i = 0;
        while (i < 6) {
            sammler.append(this.myChooserGruppen.elementAt(i).getSaveText());
            sammler.append("_5T");
            ++i;
        }
        return sammler.toString();
    }

    public Element getSaveElement() {
        Element root = BuildaHQ.getNewXMLElement("OnlineCodex");
        int i = 0;
        while (i < this.myChooserGruppen.size()) {
            if (this.myChooserGruppen.elementAt(i).getmC().size() > 1) {
                root.appendChild(this.myChooserGruppen.elementAt(i).getSaveElement());
            }
            ++i;
        }
        if (this.sonstige != null) {
            Element sonstigeRoot = BuildaHQ.getNewXMLElement("CategoryNecro");
            int i2 = 0;
            while (i2 < this.sonstige.length) {
                sonstigeRoot.appendChild(this.sonstige[i2].getSaveElement());
                ++i2;
            }
            root.appendChild(sonstigeRoot);
        }
        return root;
    }

    public void load(String saveText) {
        String[] teile = new String[]{saveText};
        String[] splittet = teile[0].split("_5T");
        int i = 0;
        while (i < this.myChooserGruppen.size()) {
            if (this.myChooserGruppen.elementAt(i).getKategorie() == 7 || this.myChooserGruppen.elementAt(i).getKategorie() == 1) {
                this.myChooserGruppen.elementAt(i).load(splittet[i]);
            }
            ++i;
        }
        i = 0;
        while (i < this.myChooserGruppen.size()) {
            if (this.myChooserGruppen.elementAt(i).getKategorie() != 7 && this.myChooserGruppen.elementAt(i).getKategorie() != 1) {
                this.myChooserGruppen.elementAt(i).load(splittet[i]);
            }
            ++i;
        }
    }

    public void loadElement(Element e) {
        int id;
        Element child;
        int j;
        ChooserGruppe c;
        NodeList childrenChooserGruppe = e.getElementsByTagName("Category");
        int childrenMax = this.myChooserGruppen.size() > childrenChooserGruppe.getLength() ? childrenChooserGruppe.getLength() : this.myChooserGruppen.size();
        int i = 0;
        while (i < this.myChooserGruppen.size()) {
            c = this.myChooserGruppen.elementAt(i);
            if (c.getKategorie() == 1 || c.getKategorie() == 7) {
                j = 0;
                while (j < childrenMax) {
                    child = (Element)childrenChooserGruppe.item(j);
                    id = Integer.parseInt(child.getAttribute("id"));
                    if ((id == 1 || id == 7) && id == c.getKategorie()) {
                        c.loadElement(child);
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.myChooserGruppen.size()) {
            c = this.myChooserGruppen.elementAt(i);
            if (c.getKategorie() != 1 && c.getKategorie() != 7) {
                j = 0;
                while (j < childrenMax) {
                    child = (Element)childrenChooserGruppe.item(j);
                    id = Integer.parseInt(child.getAttribute("id"));
                    if (id != 1 && id != 7 && id == c.getKategorie()) {
                        c.loadElement(child);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private String getTextSonstige() {
        StringBuilder text = new StringBuilder("");
        String sterne = BuildaHQ.sterneAnzeigen ? "***************  " : "";
        String \u00fcberschrift = String.valueOf(BuildaHQ.kurzerText ? "" : "\n") + "\n" + sterne + "Sonstiges" + sterne + "\n";
        text.append(\u00fcberschrift);
        int i = 0;
        while (i < this.sonstige.length) {
            text.append(this.sonstige[i].getText());
            ++i;
        }
        if (text.toString().endsWith(", ")) {
            text = text.deleteCharAt(text.lastIndexOf(","));
        }
        text.append(String.valueOf(BuildaHQ.kurzerText ? "\n" : "") + "\n");
        return text.toString();
    }

    private String getSaveTextSonstige() {
        StringBuilder text = new StringBuilder("");
        if (this.sonstige != null) {
            int i = 0;
            while (i < this.sonstige.length) {
                text.append("_6T");
                text.append(this.sonstige[i].getSaveText("_7T"));
                ++i;
            }
        }
        return text.toString();
    }

    private Element getSaveElementSonstige() {
        Element root = BuildaHQ.getNewXMLElement("Sonstige");
        if (this.sonstige != null) {
            int i = 0;
            while (i < this.sonstige.length) {
                root.appendChild(this.sonstige[i].getSaveElement());
                ++i;
            }
        } else {
            return null;
        }
        return null;
    }

    protected void showModalDialog(String s) {
        final ModalDialog md = new ModalDialog(s, true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                md.setVisible(true);
            }
        });
    }

    protected ChooserGruppe getChooserGruppe(int i) {
        return this.myChooserGruppen.elementAt(i);
    }

    protected int getChooserAnzahl() {
        return this.myChooserGruppen.size();
    }
}

