/*
 * Decompiled with CFR 0.152.
 */
package oc;

import oc.BuildaHQ;
import oc.Eintrag;
import oc.OptionsEinzelUpgrade;
import oc.OptionsGruppeEintrag;
import oc.OptionsUpgradeGruppe;
import oc.RuestkammerStarter;
import oc.StdEnum;
import oc.Text;

public class ExtEintrag
extends Eintrag {
    protected String reflectionKennung = "";
    protected OptionsEinzelUpgrade oGeneral;
    protected boolean genSelected = false;
    protected RuestkammerStarter rkEquipment;
    protected RuestkammerStarter rkMount;
    protected RuestkammerStarter rkMagic;
    protected RuestkammerStarter rkBanner;
    protected boolean magBannerSelected = false;
    protected RuestkammerStarter rkLore;
    protected OptionsEinzelUpgrade oeM;
    protected OptionsEinzelUpgrade oeS;
    protected OptionsEinzelUpgrade oeC;
    protected OptionsUpgradeGruppe magieStufen;

    @Override
    public void refreshen() {
    }

    protected void generalAdd() {
        this.oGeneral = new OptionsEinzelUpgrade(this.ID, 10, this.cnt, "", BuildaHQ.translate("General"), 0.0, false);
        this.add(this.oGeneral);
    }

    protected void generalRefresh() {
        boolean genGlobal = this.getGlobalValueBool(Text.IV_GENERAL);
        if (genGlobal && !this.genSelected) {
            this.oGeneral.setAktiv(false);
        } else {
            this.oGeneral.setAktiv(true);
        }
        if (this.oGeneral.isSelected()) {
            if (!this.genSelected) {
                this.genSelected = true;
                BuildaHQ.setInformationVectorValue(Text.IV_GENERAL, 1);
                BuildaHQ.refreshEntries(1);
                BuildaHQ.refreshEntries(2);
            }
        } else if (this.genSelected) {
            this.genSelected = false;
            BuildaHQ.setInformationVectorValue(Text.IV_GENERAL, 0);
            BuildaHQ.refreshEntries(1);
            BuildaHQ.refreshEntries(2);
        }
    }

    protected void generalDelete() {
        if (this.genSelected) {
            BuildaHQ.setInformationVectorValue(Text.IV_GENERAL, 0);
        }
    }

    protected void rkEquipmentAdd(StdEnum e) {
        this.rkEquipmentAdd(this.reflectionKennung, e);
    }

    protected void rkEquipmentAdd(String refKenn, StdEnum e) {
        this.rkEquipment = new RuestkammerStarter(this.ID, 10, this.cnt, String.valueOf(refKenn) + "Equipment", "");
        this.rkEquipment.initKammer(e);
        this.rkEquipment.setButtonText(BuildaHQ.translate("Ausr\u00fcstung"));
        this.add(this.rkEquipment);
    }

    protected void rkMountAdd(StdEnum r) {
        this.rkMountAdd(this.reflectionKennung, r);
    }

    protected void rkMountAdd(String refKenn, StdEnum r) {
        this.rkMount = new RuestkammerStarter(this.ID, 10, this.cnt, String.valueOf(refKenn) + "Mount", "");
        this.rkMount.initKammer(r);
        this.rkMount.setButtonText(BuildaHQ.translate("Reittier"));
        this.add(this.rkMount);
    }

    protected void rkMagicEquipmentAdd(boolean ... b) {
        this.rkMagicEquipmentAdd(this.reflectionKennung, b);
    }

    protected void rkMagicEquipmentAdd(String refKenn, boolean ... b) {
        this.rkMagic = new RuestkammerStarter(this.ID, 10, this.cnt, String.valueOf(refKenn) + "MagicItems", "");
        this.rkMagic.initKammer(b);
        this.rkMagic.setButtonText(BuildaHQ.translate("Magische Gegenst\u00e4nde"));
        this.add(this.rkMagic);
    }

    protected void rkBannerAdd(String btnTxt, int grundPkt, boolean ... b) {
        this.rkBannerAdd(btnTxt, this.reflectionKennung, grundPkt, b);
    }

    protected void rkBannerAdd(String btnTxt, String refKenn, int grundPkt, boolean ... b) {
        if (grundPkt == 25) {
            this.rkBanner = new RuestkammerStarter(this.ID, 10, this.cnt, String.valueOf(refKenn) + "Banner", BuildaHQ.translate(btnTxt));
            this.rkBanner.initKammer(b);
            this.rkBanner.setUeberschriftTrotzNullKostenAusgeben(false);
        } else {
            this.rkBanner = new RuestkammerStarter(this.ID, 10, this.cnt, String.valueOf(refKenn) + "Banner", "");
            this.rkBanner.initKammer(b);
            this.rkBanner.setButtonText(BuildaHQ.translate("Magisches Banner"));
        }
        if (grundPkt != -1) {
            this.rkBanner.setGrundkosten(grundPkt);
        }
        this.add(this.rkBanner);
    }

    protected void rkBannerRefresh(String infoVector) {
        boolean bannerGlobal = this.getGlobalValueBool(infoVector);
        if (bannerGlobal && !this.magBannerSelected) {
            this.rkBanner.setAktiv(false);
        } else {
            this.rkBanner.setAktiv(true);
        }
        if (this.rkBanner.isSelected()) {
            this.magBannerSelected = true;
            BuildaHQ.setInformationVectorValue(infoVector, 1);
        } else if (this.magBannerSelected) {
            this.magBannerSelected = false;
            BuildaHQ.setInformationVectorValue(infoVector, 0);
            BuildaHQ.refreshEntries(2);
        }
    }

    protected void rkBannerRefresh(String infoVector, boolean aktiv) {
        this.rkBanner.setAktiv(aktiv);
        if (aktiv) {
            this.rkBannerRefresh(infoVector);
        }
    }

    protected void rKBannerDelete(String infoVector) {
        if (this.magBannerSelected) {
            BuildaHQ.setInformationVectorValue(infoVector, 0);
        }
    }

    protected void rkLoreAdd(boolean ... b) {
        this.rkLoreAdd(this.reflectionKennung, b);
    }

    protected void rkLoreAdd(String refKenn, boolean ... b) {
        this.rkLore = new RuestkammerStarter(this.ID, 10, this.cnt, String.valueOf(refKenn) + "MagicLores", "");
        this.rkLore.initKammer(b);
        this.rkLore.setButtonText(BuildaHQ.translate("Lehren der Magie"));
        this.add(this.rkLore);
    }

    protected void mscAdd(int m, int s, int c) {
        if (m != -1) {
            this.oeM = new OptionsEinzelUpgrade(this.ID, 10, this.cnt, "", BuildaHQ.translate("Musiker"), m);
            this.add(this.oeM);
        }
        if (s != -1) {
            this.oeS = new OptionsEinzelUpgrade(this.ID, 10, this.cnt, "", BuildaHQ.translate("Standartentr\u00e4ger"), s);
            this.add(this.oeS);
        }
        if (c != -1) {
            this.oeC = new OptionsEinzelUpgrade(this.ID, 10, this.cnt, "", BuildaHQ.translate("Champion"), c);
            this.add(this.oeC);
        }
    }

    protected void magieStufenAdd(int a, int b, int c, int d) {
        if (a != -1) {
            this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Upgrade zur 1. Stufe"), a));
        }
        if (b != -1) {
            this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Upgrade zur 2. Stufe"), b));
        }
        if (c != -1) {
            this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Upgrade zur 3. Stufe"), c));
        }
        if (d != -1) {
            this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Upgrade zur 4. Stufe"), d));
        }
        this.magieStufen = new OptionsUpgradeGruppe(this.ID, 10, this.cnt, "", this.ogE);
        this.add(this.magieStufen);
    }

    protected boolean getGlobalValueBool(String infoVector) {
        return BuildaHQ.getCountFromInformationVector(infoVector) > 0;
    }

    protected int getGlobalValueInt(String infoVector) {
        return BuildaHQ.getCountFromInformationVector(infoVector);
    }

    protected void raiseGlobelValue(String infoVector) {
        BuildaHQ.setInformationVectorValue(infoVector, this.getGlobalValueInt(infoVector) + 1);
    }

    protected void decraseGlobelValue(String infoVector) {
        BuildaHQ.setInformationVectorValue(infoVector, this.getGlobalValueInt(infoVector) - 1);
    }

    public void refreshUnikatSelten() {
        try {
            this.setUnikat(true, Integer.valueOf(budget.getText()) >= 3000 ? 4 : 2);
        }
        catch (Exception e) {
            this.setUnikat(true, 2);
        }
    }

    public void refreshUnikatElite() {
        try {
            this.setUnikat(true, Integer.valueOf(budget.getText()) >= 3000 ? 6 : 3);
        }
        catch (Exception e) {
            this.setUnikat(true, 3);
        }
    }
}

