/*
 * Decompiled with CFR 0.152.
 */
package oc;

import java.awt.BorderLayout;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import oc.BuildaHQ;
import oc.BuildaPanel;
import oc.OnlineCodex;
import oc.Sprache;
import oc.whfb.armies.VOLKBretonia;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LoadWindow
extends JPanel {
    private static final long serialVersionUID = 4239397313985019958L;
    JButton openButton;
    JButton saveButton;
    JFileChooser fc;
    private String loadText = "";
    private String loadTextAllies = "";
    private Element loadElement;

    public String getLoadText() {
        return this.loadText;
    }

    public String getLoadTextAllies() {
        return this.loadTextAllies;
    }

    public void setLoadText(String loadText) {
        this.loadText = loadText;
    }

    public void setLoadTextAllies(String loadText) {
        this.loadTextAllies = loadText;
    }

    public Element getLoadElement() {
        return this.loadElement;
    }

    public String getCurrentDir() {
        return this.fc.getCurrentDirectory().getAbsolutePath();
    }

    public LoadWindow(String currentDir) {
        super(new BorderLayout());
        if (BuildaHQ.getSprache() == Sprache.English) {
            Locale.setDefault(Locale.US);
            LoadWindow.setDefaultLocale(Locale.US);
        }
        this.fc = new JFileChooser(currentDir);
        this.fc.setDialogTitle(BuildaHQ.getSprache() == Sprache.German ? "\u00d6ffnen" : "Open");
        this.fc.setApproveButtonText(BuildaHQ.getSprache() == Sprache.German ? "\u00d6ffnen" : "Open");
        this.fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(BuildaPanel.getFileSuffix()) || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return BuildaHQ.translate(String.valueOf(BuildaPanel.getFileSuffix()) + " Dateien");
            }
        });
    }

    public void load(int game) {
        int returnVal = this.fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.fc.getSelectedFile();
            this.loadFile(file, game);
        }
    }

    public void loadFile(File file, int game) {
        String text = "";
        try {
            int gelesenInt;
            FileReader leser = new FileReader(file);
            this.loadText = "";
            while ((gelesenInt = leser.read()) != -1) {
                char gelesenChar = (char)gelesenInt;
                text = String.valueOf(text) + gelesenChar;
            }
            leser.close();
            BuildaHQ.loadWindow = true;
            StringTokenizer tokenizer = new StringTokenizer(text, ";");
            if (game == BuildaPanel.WHFB) {
                String punkte = tokenizer.nextToken();
                BuildaPanel.budget.setText(punkte);
            }
            if (game == BuildaPanel.WH40K) {
                this.loadTextAllies = tokenizer.nextToken();
            }
            this.loadText = tokenizer.nextToken();
            this.loadText = this.loadText.substring(0, this.loadText.indexOf("###"));
            if (game == BuildaPanel.WHFB) {
                BuildaHQ.Items = new Vector();
                VOLKBretonia.Vows = new HashMap();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, BuildaHQ.translate("Datei konnte nicht gelesen werden."));
            OnlineCodex.getInstance().dokumentLeeren();
        }
        BuildaHQ.setLastLoaded(file.getName());
    }

    public void loadXMLFile(File file) {
        Document doc = BuildaHQ.loadXMLFile(file, true);
        this.loadElement = doc.getDocumentElement();
    }
}

