/*
 * Decompiled with CFR 0.152.
 */
package oc;

import java.awt.FontMetrics;
import oc.OptionsButton;
import oc.OptionsGruppeEintrag;

public class OptionsButtonZaehler
extends OptionsButton {
    private int anzahl = 0;
    private int maxAnzahl;
    private double syncPreis = 0.0;

    @Override
    public double getKosten() {
        if (!this.aktiv || this.preis == -88.0) {
            return 0.0;
        }
        if (this.syncPreis != 0.0 && this.anzahl == 2) {
            return this.syncPreis;
        }
        return (double)this.anzahl * this.preis;
    }

    public int getAnzahl() {
        if (this.aktiv) {
            return this.anzahl;
        }
        return 0;
    }

    public int getRealAnzahl() {
        return this.anzahl;
    }

    public int getMaxAnzahl() {
        return this.maxAnzahl;
    }

    public OptionsButtonZaehler(int ID, int lX, int lY, String verzierung, String name, int maxAnzahl, double preis) {
        this.name = name;
        this.maxAnzahl = maxAnzahl;
        this.preis = preis;
        this.produceButton();
        this.setVerzierung(verzierung);
        this.panel.setLocation(lX, lY);
    }

    public OptionsButtonZaehler(int ID, int lX, int lY, String verzierung, OptionsGruppeEintrag e, int maxAnzahl) {
        this.syncPreis = e.getSyncPreis();
        this.name = e.getName();
        this.preis = e.getPreis();
        this.maxAnzahl = maxAnzahl;
        this.produceButton();
        this.setVerzierung(verzierung);
        this.panel.setLocation(lX, lY);
    }

    public void setMaxAnzahl(int maxAnzahl) {
        this.maxAnzahl = maxAnzahl;
        this.fontKontrolle();
        this.labelSetzen();
    }

    public void setControlledMaxAnzahl(int maxAnzahl) {
        this.maxAnzahl = maxAnzahl;
        if (this.anzahl > this.maxAnzahl || this.maxAnzahl == -88) {
            this.anzahl = 0;
        }
        this.fontKontrolle();
        this.labelSetzen();
    }

    public void setAnzahl(int anzahl) {
        this.anzahl = anzahl;
        this.fontKontrolle();
        this.labelSetzen();
    }

    public void erhoeheAnzahl() {
        if (this.aktiv) {
            ++this.anzahl;
            this.fontKontrolle();
            this.labelSetzen();
        }
    }

    public void verminderAnzahl() {
        if (this.aktiv) {
            --this.anzahl;
            this.fontKontrolle();
            this.labelSetzen();
        }
    }

    public void feuerErhoehen() {
        if (this.aktiv && (this.anzahl < this.maxAnzahl || this.maxAnzahl == -88)) {
            ++this.anzahl;
            this.fontKontrolle();
            this.labelSetzen();
        }
    }

    public void feuerVermindern() {
        if (this.aktiv && this.anzahl > 0) {
            --this.anzahl;
            this.fontKontrolle();
            this.labelSetzen();
        }
    }

    public void feuerVollmachen() {
        if (this.aktiv && this.maxAnzahl != -88) {
            this.anzahl = this.maxAnzahl;
            this.fontKontrolle();
            this.labelSetzen();
        }
    }

    public void feuerVollmachen(int i) {
        if (this.aktiv) {
            this.anzahl += i;
            this.fontKontrolle();
            this.labelSetzen();
        }
    }

    public void feuerLeermachen() {
        if (this.aktiv) {
            this.anzahl = 0;
            this.fontKontrolle();
            this.labelSetzen();
        }
    }

    public void fontKontrolle() {
        if (this.maxAnzahl != -88) {
            int bold;
            int n = bold = this.anzahl > 0 ? 1 : 0;
            if (this.anzahl == this.maxAnzahl && this.maxAnzahl != 0) {
                this.fontSetzen(bold + 2);
            } else if (this.anzahl == 0 && this.maxAnzahl == 0) {
                this.fontSetzen(2);
            } else {
                this.fontSetzen(bold + 0);
            }
        }
    }

    @Override
    public void labelSetzen() {
        FontMetrics fm = this.button.getFontMetrics(this.button.getFont());
        StringBuilder abstandshalter = new StringBuilder("");
        String punkteString = "";
        punkteString = this.preis == 0.0 ? "kostenlos" : (this.preis == -88.0 ? "" : (this.jeweils ? "jeweils " + this.entferneNullNachkomma(this.preis) + " " + "Pkt." : String.valueOf(this.entferneNullNachkomma(this.preis)) + " " + "Pkt."));
        int cnt = 0;
        cnt = this.maxAnzahl == -88 ? (230 - (fm.stringWidth(String.valueOf(this.anzahl) + "  " + (this.kurzerName != null ? this.kurzerName : this.name) + punkteString) + 30)) / fm.stringWidth(" .") : (230 - (fm.stringWidth(String.valueOf(this.anzahl) + "/" + this.maxAnzahl + "  " + (this.kurzerName != null ? this.kurzerName : this.name) + punkteString) + 30)) / fm.stringWidth(" .");
        int i = 0;
        while (i < cnt) {
            abstandshalter.append(" .");
            ++i;
        }
        if (this.maxAnzahl == -88) {
            this.button.setText(String.valueOf(this.anzahl) + "  " + (this.kurzerName != null ? this.kurzerName : this.name) + abstandshalter.toString() + punkteString);
        } else {
            this.button.setText(String.valueOf(this.anzahl) + "/" + this.maxAnzahl + "  " + (this.kurzerName != null ? this.kurzerName : this.name) + abstandshalter.toString() + punkteString);
        }
    }
}

