/*
 * Decompiled with CFR 0.152.
 */
package oc;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import oc.BuildaHQ;
import oc.OnlineCodex;
import oc.OptionsVater;
import oc.RefreshListener;
import oc.RuestkammerVater;
import oc.StdEnum;
import oc.whfb.armies.VOLKBretonia;
import org.w3c.dom.Element;

public class RuestkammerStarter
extends OptionsVater {
    private RuestkammerVater myKammer;
    private String name;
    private boolean selected;
    private boolean aktiv = true;
    private boolean legal = true;
    private boolean ueberschriftTrotzNullKostenAusgeben = false;
    private JLabel ico;
    private JButton startButton = new JButton();
    private JTextArea textArea = new JTextArea("");
    public int einrueckIndex = -1;
    private int seperator = -88;
    static final int ruestkammerIconBreite = 20;
    boolean abwaehlbar = true;
    static final Font bold = new Font("arial", 1, 12);
    static final Font plain = new Font("arial", 0, 12);
    private FocusListener closeListenerFocus = new FocusListener(){

        @Override
        public void focusLost(FocusEvent event) {
            RuestkammerStarter.this.ruestkammerClosed();
        }

        @Override
        public void focusGained(FocusEvent event) {
        }
    };
    private WindowListener closeListenerWindow = new WindowListener(){

        @Override
        public void windowClosing(WindowEvent e) {
            RuestkammerStarter.this.ruestkammerClosed();
            RuestkammerStarter.this.deselectYourself();
        }

        @Override
        public void windowClosed(WindowEvent e) {
            RuestkammerStarter.this.ruestkammerClosed();
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }
    };
    private ActionListener closeListenerAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            RuestkammerStarter.this.ruestkammerClosed();
        }
    };

    public void setSelected(boolean selected) {
        this.aktivieren(selected);
    }

    public RuestkammerVater getKammer() {
        return this.myKammer;
    }

    public int getEinrueckIndex() {
        return this.einrueckIndex;
    }

    public int getSeperator() {
        return this.seperator;
    }

    public void setSeperator(int i) {
        this.seperator = i;
    }

    public void setEinrueckIndex(int i) {
        this.einrueckIndex = i;
    }

    public void setUeberschriftTrotzNullKostenAusgeben(boolean b) {
        this.ueberschriftTrotzNullKostenAusgeben = b;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    public void setToolTipText(String s) {
        this.startButton.setToolTipText(s);
    }

    public void setName(String s) {
        this.name = s;
        this.myKammer.name = s;
    }

    public String getName() {
        return this.name;
    }

    public JButton getButton() {
        return this.startButton;
    }

    public RuestkammerStarter(int ID, int lX, int lY, String kammer, String name) {
        this.init(ID, lX, lY, kammer, name);
    }

    public RuestkammerStarter(int ID, int lX, int lY, String kammer, String name, int einrueckIndex) {
        this.einrueckIndex = einrueckIndex;
        this.init(ID, lX, lY, kammer, name);
    }

    public RuestkammerStarter(int ID, int lX, int lY, RuestkammerVater abteilung) {
        this.init(ID, lX, lY, abteilung);
    }

    public void init(int ID, int lX, int lY, String kammer, String name) {
        this.selected = false;
        this.name = name;
        this.panel.setLocation(lX - 5, lY);
        this.ico = BuildaHQ.createPictureJLabel("oc/sysimages/RuestkammerIcon.jpg");
        this.ico.setBounds(8, 6, 20, 12);
        this.panel.add(this.ico);
        this.startButton.setBounds(30, 0, 230, 22);
        this.startButton.addMouseListener(this);
        BuildaHQ.newGUIComponent(this.startButton);
        this.startButton.setBorder(null);
        this.startButton.setToolTipText(BuildaHQ.translate("\u00d6ffnet ein extra Fenster. Rechtsklick: Die Einstellungen bleiben im R\u00fcstkammer-Fenster zwar bestehen, z\u00e4hlen aber NICHT zu den Gesamtkosten."));
        this.fontSetzen(false);
        this.panel.add(this.startButton);
        this.textArea.setForeground(Color.GRAY);
        this.textArea.setEditable(false);
        this.textArea.setFocusable(false);
        this.textArea.setLocation(26, 24);
        BuildaHQ.newGUIComponent(this.textArea);
        this.panel.add(this.textArea);
        String kammerName = BuildaHQ.formZuKlassenName(kammer);
        String armyPackage = OnlineCodex.armyPackage;
        String unit = "units.";
        if (reflectionKennung == "CZ") {
            unit = "units.cz.ruestkammer.";
        }
        if (reflectionKennung == "LOC") {
            unit = "units.loc.ruestkammer.";
        }
        try {
            try {
                this.myKammer = (RuestkammerVater)Class.forName(String.valueOf(armyPackage) + unit + kammerName).newInstance();
            }
            catch (Exception e) {
                try {
                    this.myKammer = (RuestkammerVater)Class.forName(String.valueOf(armyPackage) + unit + reflectionKennungAllies.toLowerCase() + "." + kammerName).newInstance();
                }
                catch (Exception ex) {
                    try {
                        this.myKammer = (RuestkammerVater)Class.forName(String.valueOf(armyPackage) + unit + reflectionKennung.toLowerCase() + "." + kammerName).newInstance();
                    }
                    catch (Exception ex2) {
                        try {
                            this.myKammer = (RuestkammerVater)Class.forName(String.valueOf(armyPackage) + unit + "fo" + "." + kammerName).newInstance();
                        }
                        catch (Exception ex3) {
                            System.out.println(String.valueOf(armyPackage) + unit + "form" + "." + kammerName);
                            this.myKammer = (RuestkammerVater)Class.forName(String.valueOf(armyPackage) + unit + "form" + "." + kammerName).newInstance();
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            OnlineCodex.getInstance().fehler(String.valueOf(armyPackage) + "units." + reflectionKennung.toLowerCase() + "." + kammerName + ".class nicht gefunden. R\u00fcstkammer kann nicht ge\u00f6ffnet werden." + "\n" + "Bitte melden!");
            System.out.println(String.valueOf(kammerName) + ".class nicht gefunden. R\u00fcstkammer kann nicht ge\u00f6ffnet werden.");
            e.printStackTrace();
        }
        this.myKammer.setCloseListener(this.closeListenerWindow, this.closeListenerFocus, this.closeListenerAction);
        this.myKammer.setzteRefreshListener(ID);
        this.myKammer.setName(name);
        this.myKammer.setUeberschrift(name);
        if (!name.equals("")) {
            this.myKammer.setUeberschrift(String.valueOf(name) + " " + BuildaHQ.translate("R\u00fcstkammer"));
            this.myKammer.name = name;
        }
        this.sizeSetzen();
        new RefreshListener(6){

            @Override
            public void refresh() {
                if (RuestkammerStarter.this.isSelected()) {
                    RuestkammerStarter.this.textUebernehmen();
                    RuestkammerStarter.this.setLegal(RuestkammerStarter.this.legal);
                }
            }
        };
    }

    public void init(int ID, int lX, int lY, RuestkammerVater abteilung) {
        this.selected = false;
        this.name = abteilung.getName();
        this.panel.setLocation(lX - 5, lY);
        this.ico = BuildaHQ.createPictureJLabel("oc/sysimages/RuestkammerIcon.jpg");
        this.ico.setBounds(8, 6, 20, 12);
        this.panel.add(this.ico);
        this.startButton.setBounds(30, 0, 230, 22);
        this.startButton.addMouseListener(this);
        BuildaHQ.newGUIComponent(this.startButton);
        this.startButton.setBorder(null);
        this.fontSetzen(false);
        this.panel.add(this.startButton);
        this.textArea.setForeground(Color.GRAY);
        this.textArea.setEditable(false);
        this.textArea.setFocusable(false);
        this.textArea.setLocation(26, 24);
        BuildaHQ.newGUIComponent(this.textArea);
        this.panel.add(this.textArea);
        try {
            this.myKammer = abteilung;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getPanel(), String.valueOf(abteilung.getName()) + ".class" + BuildaHQ.translate("nicht gefunden. R\u00fcstkammer kann nicht ge\u00f6ffnet werden:") + " " + e.getMessage());
        }
        this.myKammer.setCloseListener(this.closeListenerWindow, this.closeListenerFocus, this.closeListenerAction);
        this.myKammer.setzteRefreshListener(ID);
        if (!abteilung.getName().equals("")) {
            this.myKammer.setUeberschrift(String.valueOf(abteilung.getName()) + " " + BuildaHQ.translate("R\u00fcstkammer"));
            this.myKammer.name = abteilung.getName();
        }
        this.sizeSetzen();
        new RefreshListener(6){

            @Override
            public void refresh() {
                if (RuestkammerStarter.this.isSelected()) {
                    RuestkammerStarter.this.textUebernehmen();
                    RuestkammerStarter.this.setLegal(RuestkammerStarter.this.legal);
                }
            }
        };
    }

    public void initKammer(boolean ... b) {
        this.myKammer.initButtons(b);
        this.labelSetzen();
    }

    public void initKammer(StdEnum r) {
        this.myKammer.initButtons(r);
        this.labelSetzen();
    }

    public void setGrundkosten(int i) {
        this.myKammer.grundkosten = i;
        this.labelSetzen();
    }

    private void labelSetzen() {
        FontMetrics fm = this.startButton.getFontMetrics(this.startButton.getFont());
        StringBuilder abstandshalter = new StringBuilder("");
        String punkteString = "";
        punkteString = this.myKammer.grundkosten == 0.0 ? BuildaHQ.translate("kostenlos") : String.valueOf(this.entferneNullNachkomma(this.myKammer.grundkosten)) + " " + BuildaHQ.translate("Pkt.");
        int cnt = (230 - (fm.stringWidth(String.valueOf(this.name) + punkteString) + 30)) / fm.stringWidth(" .");
        int i = 0;
        while (i < cnt) {
            abstandshalter.append(" .");
            ++i;
        }
        this.startButton.setText(String.valueOf(this.name) + abstandshalter.toString() + punkteString);
    }

    public void setButtonText(String s) {
        this.startButton.setText(s);
        this.myKammer.name = "";
    }

    public void setButtonText(String s, boolean hideKammerName) {
        this.startButton.setText(s);
        if (hideKammerName) {
            this.myKammer.name = "";
        }
    }

    @Override
    public void setLegal(boolean b) {
        if (b && this.myKammer.isLegal()) {
            this.startButton.setForeground(Color.BLACK);
        } else {
            this.startButton.setForeground(Color.RED);
        }
        this.legal = b;
    }

    @Override
    public boolean isLegal() {
        return this.legal;
    }

    public void setAktiv(boolean b) {
        boolean pufferAktiv = this.aktiv;
        this.aktiv = b;
        this.startButton.setEnabled(b);
        this.ico.setEnabled(b);
        if (!b) {
            this.textLeeren();
        } else if (this.selected && !pufferAktiv) {
            this.textUebernehmen();
        }
    }

    public boolean isAktiv() {
        return this.aktiv;
    }

    @Override
    public double getKosten() {
        if (this.aktiv && this.selected) {
            try {
                return this.myKammer.getKosten();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0.0;
    }

    private void sizeSetzen() {
        int textAreaHoehe;
        if (this.textArea.getText().equals("")) {
            textAreaHoehe = -5;
        } else {
            textAreaHoehe = RuestkammerStarter.vorkommen(this.textArea.getText(), "\n") + 1;
            FontMetrics fm = this.textArea.getFontMetrics(this.textArea.getFont());
            textAreaHoehe *= fm.getHeight();
        }
        this.textArea.setSize(250, textAreaHoehe);
        this.panel.setSize(260, (int)this.textArea.getLocation().getY() + textAreaHoehe + 5);
    }

    @Override
    public String getLabel() {
        return "";
    }

    private void uebernehmen() {
        this.myKammer.setVisible(false);
        RefreshListener.fireRefresh();
    }

    private void textLeeren() {
        this.textArea.setText("");
        this.sizeSetzen();
    }

    public void setAbwaehlbar(boolean b) {
        this.abwaehlbar = b;
        if (!b) {
            this.selected = true;
            this.fontSetzen(true);
        }
    }

    private void aktivieren(boolean visible) {
        this.selected = true;
        this.fontSetzen(true);
        this.myKammer.setVisible(visible);
        RefreshListener.fireRefresh();
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (!this.aktiv) {
            return;
        }
        this.setSelected(event.getButton() == 1, true);
    }

    private void setSelected(boolean select, boolean visible) {
        if (select) {
            boolean wasSelected = this.selected;
            this.aktivieren(visible);
            if (!wasSelected && !BuildaHQ.loadWindow) {
                this.addSelection();
            }
        } else if (this.abwaehlbar) {
            if (this.myKammer.toString().indexOf("Abteilung") != -1 && this.myKammer.getKosten() > 0.0) {
                JOptionPane op = new JOptionPane("Bitte die Anzahl der Modelle auf '0' setzen.", 2);
                JDialog dialog = op.createDialog("Hinweis");
                dialog.setAlwaysOnTop(true);
                dialog.setModal(true);
                dialog.setDefaultCloseOperation(2);
                dialog.setVisible(true);
                return;
            }
            this.selected = false;
            this.fontSetzen(false);
            this.myKammer.setVisible(false);
            this.removeSelection();
            this.textLeeren();
            RefreshListener.fireRefresh();
        }
    }

    private void removeSelection() {
        if (this.myKammer.toString().indexOf("MagicItems") != -1 || this.myKammer.toString().indexOf("Banner") != -1 || this.myKammer.toString().indexOf("Gabe") != -1 || this.myKammer.toString().indexOf("GiftsOf") != -1 || this.myKammer.toString().indexOf("Spites") != -1 || this.myKammer.toString().indexOf("Assassin") != -1) {
            StringTokenizer tokenizer = new StringTokenizer(this.myKammer.getText(), ",");
            while (tokenizer.hasMoreElements()) {
                String tok = BuildaHQ.translate(tokenizer.nextToken().trim());
                if (tok.indexOf("Tugend") != -1 && reflectionKennung.equals("BT")) {
                    int kost = 2;
                    if (!VOLKBretonia.Vows.containsKey(tok)) continue;
                    kost = VOLKBretonia.Vows.get(tok);
                    if (--kost <= 1) {
                        kost = 1;
                        VOLKBretonia.Vows.remove(tok);
                        continue;
                    }
                    VOLKBretonia.Vows.put(tok, kost);
                    continue;
                }
                if (BuildaHQ.Items == null || !BuildaHQ.Items.contains(tok)) continue;
                BuildaHQ.Items.remove(tok);
            }
        }
    }

    private void addSelection() {
        if (this.myKammer.toString().indexOf("MagicItems") != -1 || this.myKammer.toString().indexOf("Banner") != -1 || this.myKammer.toString().indexOf("Gabe") != -1 || this.myKammer.toString().indexOf("GiftsOf") != -1 || this.myKammer.toString().indexOf("Spites") != -1 || this.myKammer.toString().indexOf("Assassin") != -1) {
            StringTokenizer tokenizer = new StringTokenizer(this.myKammer.getText(), ",");
            while (tokenizer.hasMoreElements()) {
                String tok = BuildaHQ.translate(tokenizer.nextToken().trim());
                if (tok.indexOf("Tugend") != -1 && reflectionKennung.equals("BT")) {
                    int kost = 2;
                    if (VOLKBretonia.Vows.containsKey(tok)) {
                        kost = VOLKBretonia.Vows.get(tok);
                        ++kost;
                    }
                    VOLKBretonia.Vows.put(tok, kost);
                    continue;
                }
                if (BuildaHQ.Items != null && BuildaHQ.Items.contains(tok)) {
                    JOptionPane op = new JOptionPane(String.valueOf(tok) + " " + BuildaHQ.translate("darf nur einmal enthalten sein."), 0);
                    JDialog dialog = op.createDialog(BuildaHQ.translate("Fehler"));
                    dialog.setAlwaysOnTop(true);
                    dialog.setModal(true);
                    dialog.setDefaultCloseOperation(2);
                    dialog.setVisible(true);
                }
                if (BuildaHQ.Items == null) continue;
                BuildaHQ.Items.add(tok);
            }
        }
    }

    public void deselectYourself() {
        if (this.abwaehlbar) {
            this.selected = false;
            this.fontSetzen(false);
            this.myKammer.setVisible(false);
            this.textLeeren();
            RefreshListener.fireRefresh();
        }
    }

    private void fontSetzen(boolean b) {
        if (b) {
            this.startButton.setFont(bold);
            this.textUebernehmen();
        } else {
            this.startButton.setFont(plain);
            this.textLeeren();
        }
    }

    private void ruestkammerClosed() {
        this.textUebernehmen();
        this.uebernehmen();
    }

    @Override
    public String getText() {
        if (this.aktiv && this.selected) {
            StringBuilder textPuffer = new StringBuilder();
            if (this.myKammer.grundkosten != 0.0 || this.ueberschriftTrotzNullKostenAusgeben) {
                if (BuildaHQ.allePunktkosten && this.myKammer.grundkosten != 0.0) {
                    textPuffer.append(BuildaHQ.formatierFett(String.valueOf(this.name) + "   " + this.entferneNullNachkomma(this.myKammer.grundkosten) + " " + BuildaHQ.translate("Pkt.")));
                } else {
                    textPuffer.append(BuildaHQ.formatierFett(this.name));
                }
            }
            textPuffer.append(this.myKammer.getText());
            if (textPuffer.toString().length() == 0) {
                return "";
            }
            String result = BuildaHQ.kurzerText ? String.valueOf(textPuffer.toString()) + "  -> " + this.entferneNullNachkomma(this.getKosten()) + " " + BuildaHQ.translate("Pkt.") : textPuffer.toString();
            String einrueckString = BuildaHQ.getEinrueckString();
            String randabstand = BuildaHQ.getStringXMal(einrueckString, this.einrueckIndex);
            return "\n" + randabstand + "+ " + result.replace("\n", "\n" + randabstand + einrueckString);
        }
        return "";
    }

    @Override
    public String getSaveText() {
        return String.valueOf(this.isSelected() ? "Y" : "N") + "|" + this.myKammer.getSaveText(this.einrueckIndex > 0 ? "_2U" : "_2T");
    }

    @Override
    public Element getSaveElement() {
        Element root = this.myKammer.getSaveElement();
        root.setAttribute("selected", Boolean.toString(this.isSelected()));
        return root;
    }

    @Override
    public void load(String s) {
        this.myKammer.load(s.substring(s.indexOf("|") + "|".length(), s.length()), this.einrueckIndex > 0 ? "_2U" : "_2T");
        this.textArea.setText(this.myKammer.getText().replace(", ", "\n- ").trim());
        this.sizeSetzen();
        this.setSelected(s.substring(0, 1).equals("Y"), false);
        this.myKammer.setVisible(false);
    }

    @Override
    public void loadElement(Element e) {
        this.myKammer.loadElement(e);
        this.textArea.setText(this.myKammer.getText().replace(", ", "\n- ").trim());
        this.sizeSetzen();
        this.setSelected(Boolean.parseBoolean(e.getAttribute("selected")), false);
        this.myKammer.setVisible(false);
    }

    public void deleteYourself() {
        this.removeSelection();
        this.myKammer.deleteYourself();
    }

    public static int vorkommen(String Sa, String b) {
        int vorkommen = 0;
        String a = Sa;
        if (a.equals("") || b.equals("")) {
            return 0;
        }
        while (a.contains(b)) {
            a = a.substring(a.indexOf(b) + 1, a.length());
            ++vorkommen;
        }
        return vorkommen;
    }

    public void textUebernehmen() {
        this.textArea.setText(this.myKammer.getText().replace(", ", "\n- ").trim());
        this.sizeSetzen();
    }
}

