/*
 * Decompiled with CFR 0.152.
 */
package oc;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oc.BuildaHQ;
import oc.BuildaPanel;
import oc.BuildaSTK;
import oc.OnlineCodex;
import oc.Sprache;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SaveTextWindow
extends JDialog
implements BuildaSTK {
    private static final long serialVersionUID = 1L;
    private String saveText = "";
    private String saveTextAllies = "";
    private String armyList;
    private JFileChooser fc;
    public static final String TOKEN = "###";

    public String getCurrentDir() {
        return this.fc.getCurrentDirectory().getAbsolutePath();
    }

    public String getSaveText() {
        return this.saveText;
    }

    public String getSaveTextAllies() {
        return this.saveTextAllies;
    }

    public void setSaveText(String saveText) {
        this.saveText = saveText;
    }

    public void setSaveTextAllies(String saveText) {
        this.saveTextAllies = saveText;
    }

    public void setArmyList(String armyList) {
        this.armyList = armyList;
    }

    public SaveTextWindow(JFrame owner, String currentDir) {
        super(owner, BuildaHQ.translate("Speichern"), true);
        if (BuildaHQ.getSprache() == Sprache.English) {
            Locale.setDefault(Locale.US);
        }
        this.fc = new JFileChooser(currentDir);
        this.fc.setDialogTitle(BuildaHQ.getSprache() == Sprache.German ? "Speichern" : "Save");
        this.fc.setApproveButtonText(BuildaHQ.getSprache() == Sprache.German ? "Speichern" : "Save");
        this.fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith("." + BuildaPanel.getFileSuffix()) || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return BuildaHQ.translate("oc Dateien");
            }
        });
        this.fc.setSelectedFile(BuildaHQ.getLastLoaded() == null ? new File("." + BuildaPanel.getFileSuffix()) : new File(BuildaHQ.getLastLoaded()));
        this.setDefaultCloseOperation(2);
        this.fc.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("directoryChanged".equals(e.getPropertyName())) {
                    OnlineCodex.getInstance().getPrefs().put("saveDirectory", SaveTextWindow.this.getCurrentDir());
                }
            }
        });
    }

    public void save() {
        int returnVal = this.fc.showSaveDialog(this);
        if (returnVal == 0) {
            File file = this.fc.getSelectedFile();
            String saveText = String.valueOf(BuildaPanel.budget.getText()) + ";" + this.getSaveTextAllies() + ";" + this.getSaveText() + TOKEN + this.armyList;
            try {
                if (file.getName().endsWith("." + BuildaPanel.getFileSuffix())) {
                    FileWriter writer = new FileWriter(file);
                    writer.write(saveText);
                    ((Writer)writer).close();
                } else {
                    FileWriter writer = new FileWriter(file + "." + BuildaPanel.getFileSuffix());
                    writer.write(saveText);
                    ((Writer)writer).close();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, BuildaHQ.translate("Datei konnte nicht gespeichert werden."));
            }
        }
    }

    public void writeXML() {
        Element root = OnlineCodex.getInstance().getSaveElement();
        Document d = BuildaHQ.getXMLDocument();
        d.appendChild(root);
        Writer writer = null;
        try {
            File file = new File(String.valueOf(this.fc.getSelectedFile().getAbsolutePath()) + ".xml");
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        try {
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                DOMSource source = new DOMSource(d);
                StreamResult result = new StreamResult(writer);
                transformer.transform(source, result);
            }
            catch (TransformerConfigurationException ex) {
                ex.printStackTrace();
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            catch (TransformerException ex) {
                ex.printStackTrace();
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }
}

