/*
 * Decompiled with CFR 0.152.
 */
package oc.legacy.whfb.units.or2006;

import oc.BuildaHQ;
import oc.OptionsEinzelUpgrade;
import oc.OptionsGruppeEintrag;
import oc.OptionsUpgradeGruppe;
import oc.RuestkammerVater;
import oc.StdEnum;

public class OR2006Mount
extends RuestkammerVater {
    OptionsUpgradeGruppe o1;
    OptionsGruppeEintrag oe;
    boolean isLord = false;
    boolean isMage = false;
    boolean isOrc = false;
    boolean isGoblin = false;
    boolean isNightGoblin = false;
    OptionsEinzelUpgrade addO;
    OptionsEinzelUpgrade addG;
    OptionsEinzelUpgrade addW;
    boolean isChariot = false;

    public OR2006Mount() {
        this.grundkosten = 0.0;
    }

    @Override
    public void initButtons(boolean ... defaults) {
        this.isLord = defaults[0];
        this.isMage = defaults[1];
        this.isOrc = defaults[2];
        this.isGoblin = defaults[3];
        this.isNightGoblin = defaults[4];
        if (this.isOrc) {
            this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Wildschwein"), this.isLord ? 24 : 16));
            if (this.isLord || !this.isMage) {
                this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Wildschwein-Streitwagen"), 80.0));
            }
            if (this.isLord) {
                this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Lindwurm"), 200.0));
            }
        } else if (this.isGoblin || this.isNightGoblin) {
            this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Riesenwolf"), this.isLord ? 16 : 12));
            this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Wolfsstreitwagen"), 60.0));
            if (!this.isMage) {
                this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Gigantula"), 40.0));
            }
            if (!this.isMage) {
                this.oe = new OptionsGruppeEintrag(BuildaHQ.translate("Gro\u00dfer H\u00f6hlensquig"), 50.0);
                this.ogE.addElement(this.oe);
            }
        }
        this.o1 = new OptionsUpgradeGruppe(this.ID, 10, this.cnt, "", this.ogE);
        this.add(this.o1);
        this.setUeberschrift(BuildaHQ.translate("Reittier"));
        if (this.isOrc) {
            if (this.isLord || !this.isMage) {
                this.seperator();
                this.addO = new OptionsEinzelUpgrade(this.ID, 10, this.cnt, "option", BuildaHQ.translate("Zus\u00e4tzlicher Ork"), 5.0);
                this.add(this.addO);
                this.addO.setAktiv(false);
            }
        } else if (this.isGoblin || this.isNightGoblin) {
            this.seperator();
            this.addG = new OptionsEinzelUpgrade(this.ID, 10, this.cnt, "option", BuildaHQ.translate("Zus\u00e4tzlicher Goblin"), 3.0);
            this.add(this.addG);
            this.addW = new OptionsEinzelUpgrade(this.ID, 10, this.cnt, "option", BuildaHQ.translate("Zus\u00e4tzlicher Riesenwolf"), 3.0);
            this.add(this.addW);
            this.addG.setAktiv(false);
            this.addW.setAktiv(false);
        }
        this.sizeSetzen(100, 100, 285, 85 + this.cnt + 10);
    }

    @Override
    public void refreshen() {
        if (this.o1.isSelected(BuildaHQ.translate("Wolfsstreitwagen")) || this.o1.isSelected(BuildaHQ.translate("Wildschwein-Streitwagen"))) {
            if (!this.isChariot) {
                this.isChariot = true;
                this.selectChariotOptions(this.isChariot);
            }
        } else if (this.isChariot) {
            this.isChariot = false;
            this.selectChariotOptions(this.isChariot);
        }
    }

    @Override
    public void specialAction(boolean ... action) {
        this.isNightGoblin = action[0];
        this.o1.setAktiv(BuildaHQ.translate("Gro\u00dfer H\u00f6hlensquig"), action[0]);
        if (this.isMage) {
            this.o1.setAktiv(BuildaHQ.translate("Riesenwolf"), !this.isNightGoblin);
            this.o1.setAktiv(BuildaHQ.translate("Wolfsstreitwagen"), !this.isNightGoblin);
        }
    }

    public void selectChariotOptions(boolean isChariot) {
        if (this.isOrc) {
            if (this.isLord || !this.isMage) {
                this.addO.setAktiv(isChariot);
            }
        } else if (this.isGoblin || this.isNightGoblin) {
            this.addG.setAktiv(isChariot);
            this.addW.setAktiv(isChariot);
        }
    }

    @Override
    public void initButtons(StdEnum e) {
    }
}

