/*
 * Decompiled with CFR 0.152.
 */
package oc.legacy.whfb.units.sl;

import oc.BuildaHQ;
import oc.OptionsGruppeEintrag;
import oc.OptionsZaehlerGruppe;
import oc.RuestkammerVater;
import oc.StdEnum;

public class SLStandarte
extends RuestkammerVater {
    OptionsZaehlerGruppe oz1;
    OptionsZaehlerGruppe oz2;
    boolean isAST = false;
    boolean ValayaSelected = false;
    boolean StromniSelected = false;
    boolean AngstSelected = false;
    boolean GrungniSelected = false;
    int maxCosts = 0;
    double totalCosts = 0.0;

    public SLStandarte() {
        this.grundkosten = 0.0;
    }

    @Override
    public void initButtons(boolean ... defaults) {
        this.isAST = defaults[0];
        if (!this.isAST) {
            this.maxCosts = 50;
        }
        if (this.isAST) {
            this.maxCosts = 210;
        }
        if (this.maxCosts >= 100) {
            this.ogE.addElement(new OptionsGruppeEintrag("Valayas Meisterrune", "Meisterrune der Valaya", 100.0));
        }
        if (this.maxCosts >= 100) {
            this.ogE.addElement(new OptionsGruppeEintrag("Stromnis Meisterrune", "Stromni Rotbarts Meisterrune", 100.0));
        }
        if (this.maxCosts >= 75) {
            this.ogE.addElement(new OptionsGruppeEintrag("Meisterrune der Angst", 75.0));
        }
        this.ogE.addElement(new OptionsGruppeEintrag("Meisterrune des Grimnir", 50.0));
        this.ogE.addElement(new OptionsGruppeEintrag("Grungnis Meisterrune", 50.0));
        this.oz2 = new OptionsZaehlerGruppe(this.ID, 10, this.cnt, "option", this.ogE, 1);
        this.add(this.oz2);
        if (this.maxCosts >= 55) {
            this.ogE.addElement(new OptionsGruppeEintrag("Marschrune", 55.0));
        }
        this.ogE.addElement(new OptionsGruppeEintrag("Langsamkeitsrune", 50.0));
        this.ogE.addElement(new OptionsGruppeEintrag("Mutrune", 30.0));
        if (this.isAST) {
            this.ogE.addElement(new OptionsGruppeEintrag("W\u00e4chterrune", 30.0));
        }
        this.ogE.addElement(new OptionsGruppeEintrag("Kampfrune", 25.0));
        this.ogE.addElement(new OptionsGruppeEintrag("Unbeirrbarkeitsrune", 25.0));
        this.ogE.addElement(new OptionsGruppeEintrag("Entschlossenheitsrune", 20.0));
        this.ogE.addElement(new OptionsGruppeEintrag("Arkane Schutzrune", "Rune des arkanen Schutzes", 15.0));
        this.ogE.addElement(new OptionsGruppeEintrag("Rune der Vorfahren", 10.0));
        this.oz1 = new OptionsZaehlerGruppe(this.ID, 10, this.cnt, "option", this.ogE, 3);
        this.add(this.oz1);
        this.seperator();
        this.sizeSetzen(100, 100, 285, 85 + this.cnt + 10);
    }

    @Override
    public void refreshen() {
        boolean GrungniGlobal;
        boolean AngstGlobal;
        boolean StromniGlobal;
        boolean ValayaGlobal;
        this.oz1.setMaxAnzahl(this.oz2.isSelected() ? 2 : 3);
        this.oz2.setMaxAnzahl(this.oz1.getAnzahl() >= 3 ? 0 : 1);
        this.totalCosts = this.oz1.getKosten() + this.oz2.getKosten();
        if (this.isAST) {
            if (this.totalCosts > (double)this.maxCosts) {
                this.showErrorMessage("Maximal " + this.maxCosts + " Punkte!");
                this.setButtonState(false);
            } else {
                this.hideErrorMessage();
                this.setButtonState(true);
            }
        } else if (this.totalCosts > (double)this.maxCosts) {
            this.showErrorMessage("Punktkosten um " + this.entferneNullNachkomma(this.totalCosts - (double)this.maxCosts) + " zu hoch");
            this.setButtonState(false);
        } else {
            this.showErrorMessage("Punktkosten: " + this.entferneNullNachkomma(this.totalCosts) + "/" + this.maxCosts);
            this.setButtonState(true);
        }
        boolean bl = ValayaGlobal = BuildaHQ.getCountFromInformationVector("ZWValaya") > 0;
        if (ValayaGlobal && !this.ValayaSelected) {
            this.oz2.setAktiv("Meisterrune der Valaya", false);
        } else {
            this.oz2.setAktiv("Meisterrune der Valaya", true);
        }
        if (this.oz2.isSelected("Meisterrune der Valaya")) {
            this.ValayaSelected = true;
            BuildaHQ.setInformationVectorValue("ZWValaya", 1);
        } else if (this.ValayaSelected) {
            this.ValayaSelected = false;
            BuildaHQ.setInformationVectorValue("ZWValaya", 0);
        }
        boolean bl2 = StromniGlobal = BuildaHQ.getCountFromInformationVector("ZWStromni") > 0;
        if (StromniGlobal && !this.StromniSelected) {
            this.oz2.setAktiv("Stromni Rotbarts Meisterrune", false);
        } else {
            this.oz2.setAktiv("Stromni Rotbarts Meisterrune", true);
        }
        if (this.oz2.isSelected("Stromni Rotbarts Meisterrune")) {
            this.StromniSelected = true;
            BuildaHQ.setInformationVectorValue("ZWStromni", 1);
        } else if (this.StromniSelected) {
            this.StromniSelected = false;
            BuildaHQ.setInformationVectorValue("ZWStromni", 0);
        }
        boolean bl3 = AngstGlobal = BuildaHQ.getCountFromInformationVector("ZWAngst") > 0;
        if (AngstGlobal && !this.AngstSelected) {
            this.oz2.setAktiv("Meisterrune der Angst", false);
        } else {
            this.oz2.setAktiv("Meisterrune der Angst", true);
        }
        if (this.oz2.isSelected("Meisterrune der Angst")) {
            this.AngstSelected = true;
            BuildaHQ.setInformationVectorValue("ZWAngst", 1);
        } else if (this.AngstSelected) {
            this.AngstSelected = false;
            BuildaHQ.setInformationVectorValue("ZWAngst", 0);
        }
        boolean bl4 = GrungniGlobal = BuildaHQ.getCountFromInformationVector("ZWGrungni") > 0;
        if (GrungniGlobal && !this.GrungniSelected) {
            this.oz2.setAktiv("Grungnis Meisterrune", false);
        } else {
            this.oz2.setAktiv("Grungnis Meisterrune", true);
        }
        if (this.oz2.isSelected("Grungnis Meisterrune")) {
            this.GrungniSelected = true;
            BuildaHQ.setInformationVectorValue("ZWGrungni", 1);
        } else if (this.GrungniSelected) {
            this.GrungniSelected = false;
            BuildaHQ.setInformationVectorValue("ZWGrungni", 0);
        }
        BuildaHQ.refreshEntries(2);
        BuildaHQ.refreshEntries(3);
        BuildaHQ.refreshEntries(4);
    }

    @Override
    public void deleteYourself() {
        if (this.ValayaSelected) {
            BuildaHQ.setInformationVectorValue("ZWValaya", 0);
        }
        if (this.StromniSelected) {
            BuildaHQ.setInformationVectorValue("ZWStromni", 0);
        }
        if (this.AngstSelected) {
            BuildaHQ.setInformationVectorValue("ZWAngst", 0);
        }
        if (this.GrungniSelected) {
            BuildaHQ.setInformationVectorValue("ZWGrungni", 0);
        }
    }

    @Override
    public void initButtons(StdEnum e) {
    }
}

