/*
 * Decompiled with CFR 0.152.
 */
package oc.utils;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import oc.OnlineCodex;

public class FindeClasse {
    public static HashMap<String, Class> einheitenObjListe(String reflectionKennung) {
        HashMap<String, Class> unitClassList = new HashMap<String, Class>();
        try {
            ArrayList<Class> classList = null;
            String al = "oc.whfb.units." + reflectionKennung.toLowerCase() + ".unit";
            File f = null;
            f = new File(OnlineCodex.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            classList = f.toString().endsWith(".jar") ? FindeClasse.findClassesinJar(al) : FindeClasse.getClasses(al);
            for (Class c : classList) {
                String n = c.getSimpleName();
                unitClassList.put(n, c);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return unitClassList;
    }

    public static ArrayList<Class> findClassesinJar(String packageName) {
        ArrayList<Class> classes = new ArrayList<Class>();
        try {
            File f = new File(OnlineCodex.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            JarFile jarFile = new JarFile(f);
            Enumeration<JarEntry> e = jarFile.entries();
            URL[] urls = new URL[]{new URL("jar:file:" + f.getPath() + "!/")};
            URLClassLoader cl = URLClassLoader.newInstance(urls);
            while (e.hasMoreElements()) {
                JarEntry je = e.nextElement();
                if (je.isDirectory() || !je.getName().endsWith(".class")) continue;
                String className = je.getName().substring(0, je.getName().length() - 6);
                if (!(className = className.replace("/", ".")).startsWith(packageName)) continue;
                Class<?> c = cl.loadClass(className);
                classes.add(c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classes;
    }

    public static ArrayList<Class> getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (File directory : dirs) {
            classes.addAll(FindeClasse.findClasses(directory, packageName));
        }
        return classes;
    }

    private static List<Class> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList<Class> classes = new ArrayList<Class>();
        if (!directory.exists()) {
            return classes;
        }
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(FindeClasse.findClasses(file, String.valueOf(packageName) + "." + file.getName()));
            } else if (file.getName().endsWith(".class")) {
                classes.add(Class.forName(String.valueOf(packageName) + '.' + file.getName().substring(0, file.getName().length() - 6)));
            }
            ++n2;
        }
        return classes;
    }
}

