/*
 * Decompiled with CFR 0.152.
 */
package oc.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import oc.utils.RSSItem;
import oc.utils.RSSReader;

public class UpdateNotifier {
    private static UpdateNotifier uniqueInstance = null;

    public static UpdateNotifier getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new UpdateNotifier();
        }
        return uniqueInstance;
    }

    private UpdateNotifier() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JEditorPane jEditorPane = new JEditorPane();
                jEditorPane.setEditable(false);
                JScrollPane scrollPane = new JScrollPane(jEditorPane);
                HTMLEditorKit kit = new HTMLEditorKit();
                jEditorPane.setEditorKit(kit);
                StyleSheet styleSheet = kit.getStyleSheet();
                styleSheet.addRule("body {color:#000; font-family:arial, verdana, helvetica; margin: 4px;}");
                styleSheet.addRule("h1 {font-size: 18pt; color: #cc0000; font-weight: bold; margin: 10px 0;}");
                styleSheet.addRule("h2 {font-size: 15pt; color: #4a555a; font-weight: bold; margin: 10px 0;}");
                styleSheet.addRule("p {font-size: 12pt; margin: 10px 0 20px 20px;}");
                RSSReader reader = RSSReader.getInstance();
                ArrayList<RSSItem> feedData = reader.readFeed();
                StringBuilder sb = new StringBuilder();
                for (RSSItem item : feedData) {
                    sb.append(item.toString());
                }
                String htmlString = String.format("<html>\n<body>\n<h1>Eine neue Version ist verf\u00fcgbar!</h1>\n%s\n</body>\n", sb.toString());
                Document doc = kit.createDefaultDocument();
                jEditorPane.setDocument(doc);
                jEditorPane.setText(htmlString);
                jEditorPane.setCaretPosition(0);
                JFrame frame = new JFrame("OnlineCodex Update-Service");
                frame.getContentPane().add((Component)scrollPane, "Center");
                frame.setDefaultCloseOperation(1);
                frame.setSize(new Dimension(800, 600));
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }
}

