/*
 * Decompiled with CFR 0.152.
 */
package oc.whfb.units.bt;

import oc.BuildaHQ;
import oc.OptionsGruppeEintrag;
import oc.OptionsUpgradeGruppeVows;
import oc.RuestkammerVater;
import oc.StdEnum;
import oc.whfb.armies.VOLKBretonia;

public class BTTugend
extends RuestkammerVater {
    OptionsUpgradeGruppeVows oTugend;
    private int maxCosts = 25;

    public BTTugend() {
        this.grundkosten = 0.0;
    }

    @Override
    public void initButtons(boolean ... defaults) {
        if (defaults[0]) {
            this.maxCosts = 50;
        }
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Tugend des ritterlichen Zorns"), 40.0));
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Tugend der Tapferkeit"), 40.0));
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Tugend der Entsagung"), 40.0));
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Tugend d. ungest. Ritters"), BuildaHQ.translate("Tugend des ungest\u00fcmen Ritters"), 35.0));
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Tugend des ritterlichen Ideals"), 35.0));
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Tugend der Sturheit"), 35.0));
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Tugend des Heldenmuts"), 30.0));
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Tugend der Pflicht"), 30.0));
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Tugend des Selbstvertrauens"), 25.0));
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Tugend der Tjoste"), 25.0));
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Tugend d. ritterl. Verachtung"), BuildaHQ.translate("Tugend der ritterlichen Verachtung"), 20.0));
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Tugend der Reinheit"), 20.0));
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Tugend der Barmherzigkeit"), 10.0));
        this.oTugend = new OptionsUpgradeGruppeVows(this.ID, 20, this.cnt, "", this.ogE);
        this.add(this.oTugend);
        this.setHeadline(this.oTugend, BuildaHQ.translate("Tugenden"));
        this.setUeberschrift(BuildaHQ.translate("Tugenden"));
        this.sizeSetzen();
    }

    @Override
    public void refreshen() {
        this.refreshVows();
        double totalCosts = this.oTugend.getKosten();
        if (totalCosts > (double)this.maxCosts) {
            this.setButtonState(false);
            this.showErrorMessage("Max. " + this.maxCosts + " " + BuildaHQ.translate("Punkte"));
        } else {
            this.setButtonState(true);
            this.hideErrorMessage();
            this.showErrorMessage(String.valueOf(this.entferneNullNachkomma(totalCosts)) + " / " + this.maxCosts + " " + BuildaHQ.translate("Punkte"));
        }
    }

    public int getKost(String txt, int kost) {
        if (!VOLKBretonia.Vows.containsKey(txt)) {
            return kost;
        }
        int i = VOLKBretonia.Vows.get(txt);
        return i * kost;
    }

    public void refreshVows() {
        String txt = BuildaHQ.translate("Tugend des ritterlichen Zorns");
        int cost = 40;
        if (!this.oTugend.isSelected(txt)) {
            this.oTugend.setPreis(txt, (double)this.getKost(txt, cost));
        }
        txt = BuildaHQ.translate("Tugend der Tapferkeit");
        cost = 40;
        if (!this.oTugend.isSelected(txt)) {
            this.oTugend.setPreis(txt, (double)this.getKost(txt, cost));
        }
        txt = BuildaHQ.translate("Tugend der Entsagung");
        cost = 40;
        if (!this.oTugend.isSelected(txt)) {
            this.oTugend.setPreis(txt, (double)this.getKost(txt, cost));
        }
        txt = BuildaHQ.translate("Tugend d. ungest. Ritters");
        cost = 35;
        if (!this.oTugend.isSelected(txt)) {
            this.oTugend.setPreis(txt, (double)this.getKost(txt, cost));
        }
        txt = BuildaHQ.translate("Tugend des ritterlichen Ideals");
        cost = 35;
        if (!this.oTugend.isSelected(txt)) {
            this.oTugend.setPreis(txt, (double)this.getKost(txt, cost));
        }
        txt = BuildaHQ.translate("Tugend der Sturheit");
        cost = 35;
        if (!this.oTugend.isSelected(txt)) {
            this.oTugend.setPreis(txt, (double)this.getKost(txt, cost));
        }
        txt = BuildaHQ.translate("Tugend des Heldenmuts");
        cost = 30;
        if (!this.oTugend.isSelected(txt)) {
            this.oTugend.setPreis(txt, (double)this.getKost(txt, cost));
        }
        txt = BuildaHQ.translate("Tugend der Pflicht");
        cost = 30;
        if (!this.oTugend.isSelected(txt)) {
            this.oTugend.setPreis(txt, (double)this.getKost(txt, cost));
        }
        txt = BuildaHQ.translate("Tugend des Selbstvertrauens");
        cost = 25;
        if (!this.oTugend.isSelected(txt)) {
            this.oTugend.setPreis(txt, (double)this.getKost(txt, cost));
        }
        txt = BuildaHQ.translate("Tugend der Tjoste");
        cost = 25;
        if (!this.oTugend.isSelected(txt)) {
            this.oTugend.setPreis(txt, (double)this.getKost(txt, cost));
        }
        txt = BuildaHQ.translate("Tugend d. ritterl. Verachtung");
        cost = 20;
        if (!this.oTugend.isSelected(txt)) {
            this.oTugend.setPreis(txt, (double)this.getKost(txt, cost));
        }
        txt = BuildaHQ.translate("Tugend der Reinheit");
        cost = 20;
        if (!this.oTugend.isSelected(txt)) {
            this.oTugend.setPreis(txt, (double)this.getKost(txt, cost));
        }
        txt = BuildaHQ.translate("Tugend der Barmherzigkeit");
        cost = 10;
        if (!this.oTugend.isSelected(txt)) {
            this.oTugend.setPreis(txt, (double)this.getKost(txt, cost));
        }
    }

    @Override
    public void initButtons(StdEnum e) {
    }
}

