/*
 * Decompiled with CFR 0.152.
 */
package oc.whfb.units.im;

import oc.BuildaHQ;
import oc.Eintrag;
import oc.OptionsEinzelUpgrade;
import oc.RuestkammerStarter;

public class IMHauptmanndesImperiums
extends Eintrag {
    OptionsEinzelUpgrade oe;
    RuestkammerStarter rkEquipment;
    RuestkammerStarter rkMount;
    RuestkammerStarter rkBanner;
    RuestkammerStarter rkMagic;
    boolean astSelected = false;
    boolean genSelected = false;
    OptionsEinzelUpgrade oGen;

    public IMHauptmanndesImperiums() {
        this.name = BuildaHQ.translate("Hauptmann des Imperiums");
        this.grundkosten = 60.0;
        this.seperator(12);
        this.oGen = new OptionsEinzelUpgrade(this.ID, 10, this.cnt, "", BuildaHQ.translate("General"), 0.0, false);
        this.add(this.oGen);
        this.seperator();
        this.rkMount = new RuestkammerStarter(this.ID, 10, this.cnt, "IMMount", "");
        this.rkMount.initKammer(false, false, false, false, false, true, false, false);
        this.rkMount.setButtonText(BuildaHQ.translate("Reittier"));
        this.add(this.rkMount);
        this.seperator();
        this.rkEquipment = new RuestkammerStarter(this.ID, 10, this.cnt, "IMEquipment", "");
        this.rkEquipment.initKammer(false, false, false, true, false, false);
        this.rkEquipment.setButtonText(BuildaHQ.translate("Ausr\u00fcstung"));
        this.add(this.rkEquipment);
        this.seperator();
        this.rkMagic = new RuestkammerStarter(this.ID, 10, this.cnt, "IMMagicItems", "");
        this.rkMagic.initKammer(false, true, true, false, false, false, false);
        this.rkMagic.setButtonText(BuildaHQ.translate("Magische Gegenst\u00e4nde"));
        this.add(this.rkMagic);
        this.seperator();
        this.rkBanner = new RuestkammerStarter(this.ID, 10, this.cnt, "IMBanner", BuildaHQ.translate("Armeestandartentr\u00e4ger"));
        this.rkBanner.initKammer(true, true, true);
        this.rkBanner.setGrundkosten(25);
        this.add(this.rkBanner);
        this.complete();
    }

    @Override
    public void refreshen() {
        boolean genGlobal;
        boolean astGlobal;
        this.rkMagic.setAktiv(this.rkBanner.getKosten() <= 25.0);
        boolean ast = this.rkBanner.isSelected();
        this.rkEquipment.getKammer().switchEntry(BuildaHQ.translate("Lanze"), this.rkMount.getKosten() > 0.0);
        boolean bl = astGlobal = BuildaHQ.getCountFromInformationVector("IMast") > 0;
        if (astGlobal && !this.astSelected) {
            this.rkBanner.setAktiv(false);
        } else {
            this.rkBanner.setAktiv(true);
        }
        if (this.rkBanner.isSelected()) {
            this.astSelected = true;
            BuildaHQ.setInformationVectorValue("IMast", 1);
            this.rkMount.getKammer().switchEntry(BuildaHQ.translate("Pegasus"), false);
        } else if (this.astSelected) {
            this.astSelected = false;
            BuildaHQ.setInformationVectorValue("IMast", 0);
            BuildaHQ.refreshEntries(2);
            this.rkMount.getKammer().switchEntry(BuildaHQ.translate("Pegasus"), true);
        }
        boolean bl2 = genGlobal = BuildaHQ.getCountFromInformationVector("Gen") > 0;
        if (genGlobal && !this.genSelected) {
            this.oGen.setAktiv(false);
        } else {
            this.oGen.setAktiv(true);
        }
        if (this.oGen.isSelected()) {
            this.genSelected = true;
            BuildaHQ.setInformationVectorValue("Gen", 1);
        } else if (this.genSelected) {
            this.genSelected = false;
            BuildaHQ.setInformationVectorValue("Gen", 0);
            BuildaHQ.refreshEntries(2);
        }
        if (!astGlobal) {
            this.rkBanner.setAktiv(!this.oGen.isSelected());
        }
        if (!genGlobal) {
            this.oGen.setAktiv(!this.rkBanner.isSelected());
        }
    }

    @Override
    public void deleteYourself() {
        if (this.astSelected) {
            BuildaHQ.setInformationVectorValue("IMast", 0);
        }
        if (this.genSelected) {
            BuildaHQ.setInformationVectorValue("Gen", 0);
        }
        super.deleteYourself();
    }
}

