/*
 * Decompiled with CFR 0.152.
 */
package oc.whfb.units.loc.ruestkammer;

import oc.BuildaHQ;
import oc.OptionsEinzelUpgrade;
import oc.OptionsGruppeEintrag;
import oc.OptionsZaehlerGruppe;
import oc.RuestkammerVater;
import oc.StdEnum;

public class DOCDaemonengeschenke
extends RuestkammerVater {
    OptionsEinzelUpgrade oe1;
    OptionsZaehlerGruppe oz1;
    OptionsZaehlerGruppe oz2;
    int maxCosts = 0;

    public DOCDaemonengeschenke() {
        this.grundkosten = 0.0;
    }

    @Override
    public void initButtons(boolean ... defaults) {
        this.maxCosts = defaults[0] ? 100 : (defaults[1] ? 75 : 50);
        if (this.maxCosts >= 75) {
            this.oe1 = new OptionsEinzelUpgrade(this.ID, 10, this.cnt, "", BuildaHQ.translate("Erhabene Geschenke"), 75.0);
            this.add(this.oe1);
        }
        if (this.maxCosts >= 50) {
            this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("M\u00e4chtige Geschenke"), 50.0));
            this.oz1 = new OptionsZaehlerGruppe(this.ID, 10, this.cnt, "", this.ogE, this.maxCosts == 100 ? 2 : 1);
            this.add(this.oz1);
        }
        if (this.maxCosts >= 25) {
            this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Geringe Geschenke"), 25.0));
            this.oz2 = new OptionsZaehlerGruppe(this.ID, 10, this.cnt, "", this.ogE, this.maxCosts == 100 ? 2 : (this.maxCosts == 75 ? 2 : (this.maxCosts == 50 ? 2 : 1)));
            this.add(this.oz2);
        }
        this.setUeberschrift(BuildaHQ.translate("D\u00e4monengeschenke"));
        this.sizeSetzen();
    }

    @Override
    public void refreshen() {
        double totalCosts = (this.oe1 != null ? this.oe1.getKosten() : 0.0) + (this.oz1 != null ? this.oz1.getKosten() : 0.0) + this.oz2.getKosten();
        if (totalCosts > (double)this.maxCosts) {
            this.showErrorMessage("Max. " + this.entferneNullNachkomma(this.maxCosts) + " " + BuildaHQ.translate("Punkte"));
            this.setButtonState(false);
        } else {
            this.showErrorMessage(String.valueOf(this.entferneNullNachkomma(totalCosts)) + " / " + this.maxCosts + " " + BuildaHQ.translate("Punkte"));
            this.setButtonState(true);
        }
    }

    @Override
    public void initButtons(StdEnum e) {
    }
}

