/*
 * Decompiled with CFR 0.152.
 */
package oc.whfb.units.or;

import oc.BuildaHQ;
import oc.CommonMagicItems;
import oc.OptionsGruppeEintrag;
import oc.OptionsUpgradeGruppeUnique;
import oc.RuestkammerVater;
import oc.StdEnum;

public class ORBanner
extends RuestkammerVater {
    OptionsUpgradeGruppeUnique o1;
    int maxCost = 50;
    boolean isOrc = false;
    boolean isGoblin = false;
    boolean isNightGoblin = false;
    boolean isAST = false;

    public ORBanner() {
        this.grundkosten = 0.0;
    }

    @Override
    public void initButtons(boolean ... defaults) {
        this.isOrc = defaults[0];
        this.isGoblin = defaults[1];
        this.isNightGoblin = defaults[2];
        try {
            this.isAST = defaults[3];
            this.maxCost = 150;
        }
        catch (Exception e) {
            this.isAST = false;
        }
        if (this.isAST) {
            this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Morks Kriegsbanner"), 100.0));
            this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Spinnenbanner"), 85.0));
            this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Halbmondbanner"), 50.0));
        }
        CommonMagicItems.addCommonBanner(this.ogE, this.maxCost, 35);
        this.o1 = new OptionsUpgradeGruppeUnique(this.ID, 10, this.cnt, "", this.ogE);
        this.add(this.o1);
        this.setUeberschrift(BuildaHQ.translate("Magische Standarten"));
        this.sizeSetzen(100, 100, 285, 85 + this.cnt + 10);
    }

    @Override
    public void refreshen() {
        if (this.isAST) {
            this.o1.setAktiv(BuildaHQ.translate("Halbmondbanner"), this.isNightGoblin);
            this.o1.setAktiv(BuildaHQ.translate("Spinnenbanner"), this.isGoblin);
        }
    }

    @Override
    public void specialAction(boolean ... action) {
        this.isNightGoblin = action[0];
        this.isGoblin = action[1];
        this.refreshen();
    }

    @Override
    public void initButtons(StdEnum e) {
    }
}

