/*
 * Decompiled with CFR 0.152.
 */
package oc.whfb.units.or;

import oc.BuildaHQ;
import oc.OptionsEinzelUpgrade;
import oc.OptionsGruppeEintrag;
import oc.OptionsUpgradeGruppe;
import oc.RuestkammerVater;
import oc.StdEnum;

public class ORMount
extends RuestkammerVater {
    OptionsUpgradeGruppe o1;
    OptionsGruppeEintrag oe;
    boolean isLord = false;
    boolean isMage = false;
    boolean isOrc = false;
    boolean isGoblin = false;
    boolean isNightGoblin = false;
    boolean isWildork = false;
    OptionsEinzelUpgrade addO;
    OptionsEinzelUpgrade addG;
    OptionsEinzelUpgrade addW;
    OptionsEinzelUpgrade addSchrein;
    boolean isChariot = false;

    public ORMount() {
        this.grundkosten = 0.0;
    }

    @Override
    public void initButtons(boolean ... defaults) {
        this.isLord = defaults[0];
        this.isMage = defaults[1];
        this.isOrc = defaults[2];
        this.isGoblin = defaults[3];
        this.isNightGoblin = defaults[4];
        if (this.isOrc) {
            this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Wildschwein"), this.isLord ? 24 : 16));
            if (this.isLord || !this.isMage) {
                this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Wildschwein-Streitwagen"), 85.0));
            }
            if (this.isLord) {
                this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Lindwurm"), 160.0));
            }
        } else if (this.isGoblin || this.isNightGoblin) {
            this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Riesenwolf"), this.isLord ? 18 : 12));
            if (!this.isMage) {
                this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Riesenspinne"), this.isLord ? 22 : 15));
            }
            this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Wolfsstreitwagen"), 50.0));
            if (!this.isMage) {
                this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Gigantula"), this.isLord ? 50 : 40));
            }
            if (!this.isMage) {
                this.oe = new OptionsGruppeEintrag(BuildaHQ.translate("Gro\u00dfer H\u00f6hlensquig"), this.isLord ? 40 : 50);
                this.ogE.addElement(this.oe);
            }
            if (this.isMage && this.isLord) {
                this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Arachnarok-Spinne"), 290.0));
            }
        }
        this.o1 = new OptionsUpgradeGruppe(this.ID, 10, this.cnt, "", this.ogE);
        this.add(this.o1);
        this.setUeberschrift(BuildaHQ.translate("Reittier"));
        if (this.isOrc) {
            if (this.isLord || !this.isMage) {
                this.seperator();
                this.addO = new OptionsEinzelUpgrade(this.ID, 10, this.cnt, "option", BuildaHQ.translate("Zus\u00e4tzlicher Ork"), 5.0);
                this.add(this.addO);
                this.addO.setAktiv(false);
            }
        } else if (this.isGoblin || this.isNightGoblin) {
            this.seperator();
            this.addG = new OptionsEinzelUpgrade(this.ID, 10, this.cnt, "option", BuildaHQ.translate("Zus\u00e4tzlicher Goblin"), 5.0);
            this.add(this.addG);
            this.addW = new OptionsEinzelUpgrade(this.ID, 10, this.cnt, "option", BuildaHQ.translate("Zus\u00e4tzlicher Riesenwolf"), 5.0);
            this.add(this.addW);
            this.addG.setAktiv(false);
            this.addW.setAktiv(false);
            if (this.isMage && this.isLord) {
                this.addSchrein = new OptionsEinzelUpgrade(this.ID, 10, this.cnt, "option", BuildaHQ.translate("Spinn'netzschrein"), 40.0);
                this.add(this.addSchrein);
                this.addSchrein.setAktiv(false);
            }
        }
        this.sizeSetzen(100, 100, 285, 85 + this.cnt + 10);
    }

    @Override
    public void refreshen() {
        if (this.o1.isSelected(BuildaHQ.translate("Wolfsstreitwagen")) || this.o1.isSelected(BuildaHQ.translate("Wildschwein-Streitwagen"))) {
            if (!this.isChariot) {
                this.isChariot = true;
                this.selectChariotOptions(this.isChariot);
            }
        } else if (this.isChariot) {
            this.isChariot = false;
            this.selectChariotOptions(this.isChariot);
        }
        if (this.o1.isSelected(BuildaHQ.translate("Arachnarok-Spinne"))) {
            this.addSchrein.setAktiv(true);
        } else if (this.isLord && this.isMage && this.isGoblin) {
            this.addSchrein.setAktiv(false);
        }
        if (this.isWildork) {
            this.o1.setAktiv(BuildaHQ.translate("Wildschwein-Streitwagen"), false);
        } else if (this.isOrc && (this.isLord || !this.isMage)) {
            this.o1.setAktiv(BuildaHQ.translate("Wildschwein-Streitwagen"), true);
        }
        if (this.isGoblin && this.isNightGoblin && !this.isMage) {
            this.o1.setAktiv(BuildaHQ.translate("Riesenwolf"), false);
            this.o1.setAktiv(BuildaHQ.translate("Riesenspinne"), false);
            this.o1.setAktiv(BuildaHQ.translate("Wolfsstreitwagen"), false);
            this.o1.setAktiv(BuildaHQ.translate("Gigantula"), false);
            this.o1.setAktiv(BuildaHQ.translate("Gro\u00dfer H\u00f6hlensquig"), true);
        } else if (this.isGoblin && !this.isNightGoblin && !this.isMage) {
            this.o1.setAktiv(BuildaHQ.translate("Riesenwolf"), true);
            this.o1.setAktiv(BuildaHQ.translate("Riesenspinne"), true);
            this.o1.setAktiv(BuildaHQ.translate("Wolfsstreitwagen"), true);
            if (!this.isMage) {
                this.o1.setAktiv(BuildaHQ.translate("Gigantula"), true);
            }
            if (!this.isMage) {
                this.o1.setAktiv(BuildaHQ.translate("Gro\u00dfer H\u00f6hlensquig"), false);
            }
        }
    }

    @Override
    public void specialAction(boolean ... action) {
        this.isNightGoblin = action[0];
        this.o1.setAktiv(BuildaHQ.translate("Gro\u00dfer H\u00f6hlensquig"), action[0]);
        if (this.isMage) {
            this.o1.setAktiv(BuildaHQ.translate("Riesenwolf"), !this.isNightGoblin);
            this.o1.setAktiv(BuildaHQ.translate("Wolfsstreitwagen"), !this.isNightGoblin);
        }
        try {
            this.isWildork = action[1];
        }
        catch (Exception e) {
            this.isWildork = false;
        }
    }

    public void selectChariotOptions(boolean isChariot) {
        if (this.isOrc) {
            if (this.isLord || !this.isMage) {
                this.addO.setAktiv(isChariot);
            }
        } else if (this.isGoblin || this.isNightGoblin) {
            this.addG.setAktiv(isChariot);
            this.addW.setAktiv(isChariot);
        }
    }

    @Override
    public void initButtons(StdEnum e) {
    }
}

