/*
 * Decompiled with CFR 0.152.
 */
package oc.whfb.units.zw;

import java.util.Vector;
import oc.BuildaHQ;
import oc.OptionsGruppeEintrag;
import oc.OptionsUpgradeGruppe;
import oc.OptionsZaehlerGruppe;
import oc.RuestkammerVater;
import oc.StdEnum;

public class ZWMaschinenrunen
extends RuestkammerVater {
    OptionsZaehlerGruppe oz1;
    OptionsZaehlerGruppe oz2;
    OptionsZaehlerGruppe oz3;
    OptionsUpgradeGruppe o1;
    boolean isSpeer = false;
    boolean TarnungSelected = false;
    boolean OpferungSelected = false;
    int maxCosts = 0;

    public ZWMaschinenrunen() {
        this.grundkosten = 0.0;
    }

    @Override
    public void initButtons(boolean ... defaults) {
        this.isSpeer = defaults[2];
        this.maxCosts = defaults[0] ? 100 : 50;
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("MR der Opferung"), BuildaHQ.translate("Meisterrune der Opferung"), 30.0));
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("MR der Tarnung"), BuildaHQ.translate("Meisterrune der Tarnung"), 25.0));
        this.oz2 = new OptionsZaehlerGruppe(this.ID, 10, this.cnt, "option", this.ogE, 1);
        this.add(this.oz2);
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Durchschlagsrune"), 40.0));
        this.oz1 = new OptionsZaehlerGruppe(this.ID, 10, this.cnt, "option", this.ogE, 2);
        this.add(this.oz1);
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Rune der Standhaftigkeit"), 15.0));
        this.oz3 = new OptionsZaehlerGruppe(this.ID, 10, this.cnt, "option", this.ogE, 2);
        this.add(this.oz3);
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Schmiederune"), 25.0));
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Genauigkeitsrune"), 25.0));
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Flakksons Zielsuchrune"), 15.0));
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Brandrune"), 5.0));
        this.o1 = new OptionsUpgradeGruppe(this.ID, 10, this.cnt, "option", (Vector<OptionsGruppeEintrag>)this.ogE, 3);
        this.add(this.o1);
        this.setUeberschrift(BuildaHQ.translate("Maschinenrunen"));
        this.sizeSetzen();
    }

    @Override
    public void refreshen() {
        boolean OpferungGlobal;
        boolean TarnungGlobal;
        int oz1Anzahl = (this.oz2.isSelected() ? 2 : 3) - this.oz3.getAnzahl() - this.o1.getAnzahl();
        this.oz1.setMaxAnzahl(oz1Anzahl > 2 ? 2 : oz1Anzahl);
        int oz3Anzahl = (this.oz2.isSelected() ? 2 : 3) - this.oz1.getAnzahl() - this.o1.getAnzahl();
        this.oz3.setMaxAnzahl(oz3Anzahl > 2 ? 2 : oz3Anzahl);
        this.oz2.setMaxAnzahl(this.oz1.getAnzahl() + this.oz3.getAnzahl() + this.o1.getAnzahl() >= 3 ? 0 : 1);
        this.o1.setMaxAnzahl((this.oz2.isSelected() ? 2 : 3) - this.oz1.getAnzahl() - this.oz3.getAnzahl());
        this.o1.setAktiv(BuildaHQ.translate("Flakksons Zielsuchrune"), this.isSpeer);
        if (this.oz1.getAnzahl() > 1) {
            this.oz1.setPreis(BuildaHQ.translate("Durchschlagsrune"), 25.0);
        } else {
            this.oz1.setPreis(BuildaHQ.translate("Durchschlagsrune"), 40.0);
        }
        double totalCosts = this.oz1.getKosten() + this.oz2.getKosten() + this.oz3.getKosten() + this.o1.getKosten();
        if (totalCosts > (double)this.maxCosts) {
            this.showErrorMessage("Max. " + this.maxCosts + " " + BuildaHQ.translate("Punkte"));
            this.setButtonState(false);
        } else {
            this.hideErrorMessage();
            this.setButtonState(true);
        }
        boolean bl = TarnungGlobal = BuildaHQ.getCountFromInformationVector("ZWTarnung") > 0;
        if (TarnungGlobal && !this.TarnungSelected) {
            this.oz2.setAktiv(BuildaHQ.translate("Meisterrune der Tarnung"), false);
        } else {
            this.oz2.setAktiv(BuildaHQ.translate("Meisterrune der Tarnung"), true);
        }
        if (this.oz2.isSelected(BuildaHQ.translate("Meisterrune der Tarnung"))) {
            this.TarnungSelected = true;
            BuildaHQ.setInformationVectorValue("ZWTarnung", 1);
        } else if (this.TarnungSelected) {
            this.TarnungSelected = false;
            BuildaHQ.setInformationVectorValue("ZWTarnung", 0);
        }
        boolean bl2 = OpferungGlobal = BuildaHQ.getCountFromInformationVector("ZWOpferung") > 0;
        if (OpferungGlobal && !this.OpferungSelected) {
            this.oz2.setAktiv(BuildaHQ.translate("Meisterrune der Opferung"), false);
        } else {
            this.oz2.setAktiv(BuildaHQ.translate("Meisterrune der Opferung"), true);
        }
        if (this.oz2.isSelected(BuildaHQ.translate("Meisterrune der Opferung"))) {
            this.OpferungSelected = true;
            BuildaHQ.setInformationVectorValue("ZWOpferung", 1);
        } else if (this.OpferungSelected) {
            this.OpferungSelected = false;
            BuildaHQ.setInformationVectorValue("ZWOpferung", 0);
        }
        BuildaHQ.refreshEntries(4);
        BuildaHQ.refreshEntries(5);
    }

    @Override
    public void deleteYourself() {
        if (this.TarnungSelected) {
            BuildaHQ.setInformationVectorValue("ZWTarnung", 0);
        }
        if (this.OpferungSelected) {
            BuildaHQ.setInformationVectorValue("ZWOpferung", 0);
        }
    }

    @Override
    public void initButtons(StdEnum e) {
    }
}

