/*
 * Decompiled with CFR 0.152.
 */
package oc.whfb.units.zw;

import java.util.Vector;
import oc.BuildaHQ;
import oc.OptionsGruppeEintrag;
import oc.OptionsUpgradeGruppe;
import oc.OptionsZaehlerGruppe;
import oc.RuestkammerVater;
import oc.StdEnum;

public class ZWStandarte
extends RuestkammerVater {
    OptionsZaehlerGruppe oz1;
    OptionsZaehlerGruppe oz2;
    OptionsUpgradeGruppe o1;
    OptionsUpgradeGruppe o2;
    boolean isAST = false;
    boolean grothSelected = false;
    boolean stromniSelected = false;
    boolean valayaSelected = false;
    boolean grungniSelected = false;
    int maxCosts = 0;
    double totalCosts = 0.0;

    public ZWStandarte() {
        this.grundkosten = 0.0;
    }

    @Override
    public void initButtons(boolean ... defaults) {
        if (defaults[0]) {
            this.isAST = defaults[0];
            this.maxCosts = 500;
        } else {
            this.maxCosts = defaults[2] ? 75 : (defaults[1] ? 50 : 100);
        }
        if (this.isAST) {
            this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Banner d. v. St\u00e4dte"), BuildaHQ.translate("Banner der verlorenen St\u00e4dte"), 100.0));
            this.o2 = new OptionsUpgradeGruppe(this.ID, 10, this.cnt, "option", (Vector<OptionsGruppeEintrag>)this.ogE, 1);
            this.add(this.o2);
        }
        if (this.maxCosts >= 75) {
            this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Groths Meisterrune"), BuildaHQ.translate("Groth Einauges Meisterrune"), 75.0));
        }
        if (this.maxCosts >= 75) {
            this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Stromnis Meisterrune"), BuildaHQ.translate("Stromni Rotbarts Meisterrune"), 75.0));
        }
        if (this.maxCosts >= 65) {
            this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Meisterrune der Valaya"), 65.0));
        }
        if (this.maxCosts >= 60) {
            this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Grungnis Meisterrune"), 60.0));
        }
        if (this.maxCosts >= 60) {
            this.oz2 = new OptionsZaehlerGruppe(this.ID, 10, this.cnt, "option", this.ogE, 1);
            this.add(this.oz2);
        }
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Kampfrune"), 35.0));
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Langsamkeitsrune"), 35.0));
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Arkane Schutzrune"), BuildaHQ.translate("Rune des arkanen Schutzes"), 15.0));
        this.oz1 = new OptionsZaehlerGruppe(this.ID, 10, this.cnt, "option", this.ogE, 3);
        this.add(this.oz1);
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Unbeirrbarkeitsrune"), BuildaHQ.translate("Rune der Unbeirrbarkeit"), 35.0));
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Marschrune"), 35.0));
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Mutrune"), 20.0));
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Rune der Vorfahren"), 20.0));
        this.o1 = new OptionsUpgradeGruppe(this.ID, 10, this.cnt, "option", (Vector<OptionsGruppeEintrag>)this.ogE, 3);
        this.add(this.o1);
        if (this.isAST) {
            this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("W\u00e4chterrune"), 30.0));
        }
        this.ogE.addElement(new OptionsGruppeEintrag(BuildaHQ.translate("Entschlossenheitsrune"), 20.0));
        this.seperator();
        this.setUeberschrift(BuildaHQ.translate("Standarten Runen"));
        this.sizeSetzen();
    }

    @Override
    public void refreshen() {
        if (this.maxCosts >= 60) {
            this.oz1.setMaxAnzahl((this.oz2.isSelected() ? 2 : 3) - this.o1.getAnzahl());
            this.oz2.setMaxAnzahl(this.oz1.getAnzahl() + this.o1.getAnzahl() >= 3 ? 0 : 1);
            this.o1.setMaxAnzahl((this.oz2.isSelected() ? 2 : 3) - this.oz1.getAnzahl());
        } else {
            this.oz1.setMaxAnzahl(3 - this.o1.getAnzahl());
            this.o1.setMaxAnzahl(3 - this.oz1.getAnzahl());
        }
        switch (this.oz1.getAnzahl(0)) {
            case 3: {
                this.oz1.setPreis(BuildaHQ.translate("Kampfrune"), 41.7);
                break;
            }
            default: {
                this.oz1.setPreis(BuildaHQ.translate("Kampfrune"), 35.0);
            }
        }
        switch (this.oz1.getAnzahl(1)) {
            case 2: {
                this.oz1.setPreis(BuildaHQ.translate("Langsamkeitsrune"), 25.0);
                break;
            }
            case 3: {
                this.oz1.setPreis(BuildaHQ.translate("Langsamkeitsrune"), 26.7);
                break;
            }
            default: {
                this.oz1.setPreis(BuildaHQ.translate("Langsamkeitsrune"), 35.0);
            }
        }
        this.totalCosts = this.oz1.getKosten() + (this.maxCosts >= 60 ? this.oz2.getKosten() : 0.0) + this.o1.getKosten() + (this.isAST ? this.o2.getKosten() : 0.0);
        if (this.isAST) {
            if (this.totalCosts > (double)this.maxCosts) {
                this.showErrorMessage("Max. " + this.maxCosts + " " + BuildaHQ.translate("Punkte"));
                this.setButtonState(false);
            } else {
                this.hideErrorMessage();
                this.setButtonState(true);
            }
        } else if (this.totalCosts > (double)this.maxCosts) {
            this.showErrorMessage("Max. " + this.maxCosts + " " + BuildaHQ.translate("Punkte"));
            this.setButtonState(false);
        } else {
            this.showErrorMessage("");
            this.setButtonState(true);
        }
        if (this.maxCosts >= 60) {
            this.checkUniqueEntry();
        }
        BuildaHQ.refreshEntries(2);
        BuildaHQ.refreshEntries(3);
        BuildaHQ.refreshEntries(4);
    }

    private void checkUniqueEntry() {
        boolean GrungniGlobal;
        boolean ValayaGlobal;
        boolean StromniGlobal;
        boolean GrothGlobal;
        boolean bl = GrothGlobal = BuildaHQ.getCountFromInformationVector("ZWGroth") > 0;
        if (GrothGlobal && !this.grothSelected) {
            this.oz2.setAktiv(BuildaHQ.translate("Groth Einauges Meisterrune"), false);
        } else {
            this.oz2.setAktiv(BuildaHQ.translate("Groth Einauges Meisterrune"), true);
        }
        if (this.oz2.isSelected(BuildaHQ.translate("Groth Einauges Meisterrune"))) {
            this.grothSelected = true;
            BuildaHQ.setInformationVectorValue("ZWGroth", 1);
        } else if (this.grothSelected) {
            this.grothSelected = false;
            BuildaHQ.setInformationVectorValue("ZWGroth", 0);
        }
        boolean bl2 = StromniGlobal = BuildaHQ.getCountFromInformationVector("ZWStromni") > 0;
        if (StromniGlobal && !this.stromniSelected) {
            this.oz2.setAktiv(BuildaHQ.translate("Stromni Rotbarts Meisterrune"), false);
        } else {
            this.oz2.setAktiv(BuildaHQ.translate("Stromni Rotbarts Meisterrune"), true);
        }
        if (this.oz2.isSelected(BuildaHQ.translate("Stromni Rotbarts Meisterrune"))) {
            this.stromniSelected = true;
            BuildaHQ.setInformationVectorValue("ZWStromni", 1);
        } else if (this.stromniSelected) {
            this.stromniSelected = false;
            BuildaHQ.setInformationVectorValue("ZWStromni", 0);
        }
        boolean bl3 = ValayaGlobal = BuildaHQ.getCountFromInformationVector("ZWValaya") > 0;
        if (ValayaGlobal && !this.valayaSelected) {
            this.oz2.setAktiv(BuildaHQ.translate("Meisterrune der Valaya"), false);
        } else {
            this.oz2.setAktiv(BuildaHQ.translate("Meisterrune der Valaya"), true);
        }
        if (this.oz2.isSelected(BuildaHQ.translate("Meisterrune der Valaya"))) {
            this.valayaSelected = true;
            BuildaHQ.setInformationVectorValue("ZWValaya", 1);
        } else if (this.valayaSelected) {
            this.valayaSelected = false;
            BuildaHQ.setInformationVectorValue("ZWValaya", 0);
        }
        boolean bl4 = GrungniGlobal = BuildaHQ.getCountFromInformationVector("ZWGrungni") > 0;
        if (GrungniGlobal && !this.grungniSelected) {
            this.oz2.setAktiv(BuildaHQ.translate("Grungnis Meisterrune"), false);
        } else {
            this.oz2.setAktiv(BuildaHQ.translate("Grungnis Meisterrune"), true);
        }
        if (this.oz2.isSelected(BuildaHQ.translate("Grungnis Meisterrune"))) {
            this.grungniSelected = true;
            BuildaHQ.setInformationVectorValue("ZWGrungni", 1);
        } else if (this.grungniSelected) {
            this.grungniSelected = false;
            BuildaHQ.setInformationVectorValue("ZWGrungni", 0);
        }
    }

    @Override
    public void deleteYourself() {
        if (this.grothSelected) {
            BuildaHQ.setInformationVectorValue("ZWValaya", 0);
        }
        if (this.stromniSelected) {
            BuildaHQ.setInformationVectorValue("ZWStromni", 0);
        }
        if (this.valayaSelected) {
            BuildaHQ.setInformationVectorValue("ZWAngst", 0);
        }
        if (this.grungniSelected) {
            BuildaHQ.setInformationVectorValue("ZWGrungni", 0);
        }
    }

    @Override
    public void initButtons(StdEnum e) {
    }
}

